-- MySQL Administrator dump 1.4
--
-- ------------------------------------------------------
-- Server version	5.7.18


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;


--
-- Create schema postreader
--

-- CREATE DATABASE IF NOT EXISTS postreader;
-- USE postreader;

--
-- Definition of table `catalog`
--

DROP TABLE IF EXISTS `catalog`;
CREATE TABLE `catalog` (
  `idcatalog` int(11) NOT NULL AUTO_INCREMENT,
  `super_catalog_idsuper_catalog` int(11) NOT NULL,
  `language` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `catalog_num` int(11) NOT NULL,
  `catalog_code` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `group_num` int(11) DEFAULT NULL,
  PRIMARY KEY (`idcatalog`),
  KEY `fk_catalog_super_catalog1_idx` (`super_catalog_idsuper_catalog`),
  KEY `idx1_catalog` (`super_catalog_idsuper_catalog`,`catalog_num`),
  KEY `idx2_catalog` (`super_catalog_idsuper_catalog`,`catalog_code`),
  KEY `idx3_catalog` (`group_num`,`super_catalog_idsuper_catalog`),
  CONSTRAINT `fk_catalog_super_catalog1` FOREIGN KEY (`super_catalog_idsuper_catalog`) REFERENCES `super_catalog` (`idsuper_catalog`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `catalog`
--

/*!40000 ALTER TABLE `catalog` DISABLE KEYS */;
INSERT INTO `catalog` (`idcatalog`,`super_catalog_idsuper_catalog`,`language`,`catalog_num`,`catalog_code`,`description`,`group_num`) VALUES 
 (1,1,'',0,'English','Inglés',NULL),
 (2,1,'',1,'Spanish','Español',NULL),
 (3,2,'English',0,'Public','',NULL),
 (4,2,'English',1,'Private','',NULL),
 (5,2,'Spanish',0,'Pública','',NULL),
 (6,2,'Spanish',1,'Privada','',NULL),
 (7,3,'English',0,'Not','',NULL),
 (8,3,'English',1,'Yes','',NULL),
 (9,3,'Spanish',0,'No','',NULL),
 (10,3,'Spanish',1,'Sí','',NULL),
 (11,4,'English',0,'Pending','Pendiente de tratar',NULL),
 (12,4,'English',1,'Working','Gestionando el mensaje',NULL),
 (13,4,'English',2,'Finalized','Finalizado o cerrado',NULL),
 (14,4,'Spanish',0,'Pendiente','Pendiente de tratar',NULL),
 (15,4,'Spanish',1,'Tratándolo','Trabajando en su resolución',NULL),
 (16,4,'Spanish',2,'Finalizado','Finalizado o cerrado',NULL);
/*!40000 ALTER TABLE `catalog` ENABLE KEYS */;


--
-- Definition of table `companies`
--

DROP TABLE IF EXISTS `companies`;
CREATE TABLE `companies` (
  `company_id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `phone1` varchar(30) COLLATE utf8_unicode_ci DEFAULT '',
  `fax` varchar(30) COLLATE utf8_unicode_ci DEFAULT '',
  `address1` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `address2` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `city` varchar(30) COLLATE utf8_unicode_ci DEFAULT '',
  `state` varchar(30) COLLATE utf8_unicode_ci DEFAULT '',
  `zip` varchar(11) COLLATE utf8_unicode_ci DEFAULT '',
  `country` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `primary_url` varchar(255) COLLATE utf8_unicode_ci DEFAULT '',
  `owner` int(10) NOT NULL DEFAULT '0',
  `description` mediumtext COLLATE utf8_unicode_ci,
  `email` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `private` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`company_id`),
  KEY `company_name` (`name`),
  KEY `company_owner` (`owner`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `companies`
--

/*!40000 ALTER TABLE `companies` DISABLE KEYS */;
INSERT INTO `companies` (`company_id`,`name`,`phone1`,`fax`,`address1`,`address2`,`city`,`state`,`zip`,`country`,`primary_url`,`owner`,`description`,`email`,`private`) VALUES 
 (0,'Función administrativa','','','','','','','','','',4,'','info@fhumanes.com',0),
 (3,'Company 1','','','','','','','','','',4,'Test','info@fhumanes.com',0);
/*!40000 ALTER TABLE `companies` ENABLE KEYS */;


--
-- Definition of table `config`
--

DROP TABLE IF EXISTS `config`;
CREATE TABLE `config` (
  `config_id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `value` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`config_id`),
  UNIQUE KEY `config_name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `config`
--

/*!40000 ALTER TABLE `config` DISABLE KEYS */;
INSERT INTO `config` (`config_id`,`name`,`value`) VALUES 
 (1,'FOLDER_FILES','files'),
 (8,'GMAIL_Password','The real key has not been set. But here must be the password'),
 (9,'GMAIL_setFrom_email','fhumanes.pruebas@gmail.com'),
 (10,'GMAIL_setFrom_name','Fernando Humanes (pruebas)'),
 (12,'GMAIL_server','{imap.gmail.com:993/imap/ssl/novalidate-cert}INBOX'),
 (13,'ARCHIVE_Mailbox','Archivado'),
 (15,'GMAIL_Username','fhumanes.pruebas@gmail.com');
/*!40000 ALTER TABLE `config` ENABLE KEYS */;


--
-- Definition of table `contact`
--

DROP TABLE IF EXISTS `contact`;
CREATE TABLE `contact` (
  `contact_id` int(10) NOT NULL AUTO_INCREMENT,
  `companies_company_id` int(10) NOT NULL DEFAULT '0',
  `departments_dept_id` int(10) unsigned DEFAULT NULL,
  `name` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `surname` varchar(70) COLLATE utf8_unicode_ci NOT NULL,
  `email` varchar(70) COLLATE utf8_unicode_ci NOT NULL,
  `userLastUpdate` varchar(16) COLLATE utf8_unicode_ci NOT NULL,
  `dateLastUpdate` datetime NOT NULL,
  PRIMARY KEY (`contact_id`),
  KEY `user_username` (`name`),
  KEY `fk_users_companies1_idx` (`companies_company_id`),
  CONSTRAINT `fk_contacts_companies` FOREIGN KEY (`companies_company_id`) REFERENCES `companies` (`company_id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `contact`
--

/*!40000 ALTER TABLE `contact` DISABLE KEYS */;
INSERT INTO `contact` (`contact_id`,`companies_company_id`,`departments_dept_id`,`name`,`surname`,`email`,`userLastUpdate`,`dateLastUpdate`) VALUES 
 (7,3,1,'Fernando','Humanes','info@fhumanes.com','admin','2020-05-09 13:16:40'),
 (8,3,2,'Fernando','Humanes (2)','fhumanes.pruebas@gmail.com','admin','2020-05-09 13:20:34'),
 (9,3,1,'Test1','Test1','info@fhumanes.com','admin','2020-05-11 18:24:56'),
 (10,3,1,'Fernando','humanes (Gmail)','fernandohumanes@gmail.com','admin','2021-09-02 19:23:40');
/*!40000 ALTER TABLE `contact` ENABLE KEYS */;


--
-- Definition of table `departments`
--

DROP TABLE IF EXISTS `departments`;
CREATE TABLE `departments` (
  `dept_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `companies_company_id` int(10) NOT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `phone` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fax` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `desc` mediumtext COLLATE utf8_unicode_ci,
  `email` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`dept_id`),
  KEY `dept_name` (`name`),
  KEY `fk_departments_companies1_idx` (`companies_company_id`),
  CONSTRAINT `fk_departments_companies1` FOREIGN KEY (`companies_company_id`) REFERENCES `companies` (`company_id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Department heirarchy under a company';

--
-- Dumping data for table `departments`
--

/*!40000 ALTER TABLE `departments` DISABLE KEYS */;
INSERT INTO `departments` (`dept_id`,`companies_company_id`,`name`,`phone`,`fax`,`desc`,`email`) VALUES 
 (1,3,'Departament 1','','','','info@fhumanes.com'),
 (2,3,'Departament 2','','','','info@fhumanes.com');
/*!40000 ALTER TABLE `departments` ENABLE KEYS */;


--
-- Definition of table `email`
--

DROP TABLE IF EXISTS `email`;
CREATE TABLE `email` (
  `idemail` int(11) NOT NULL AUTO_INCREMENT,
  `FromEmail` varchar(100) CHARACTER SET utf8 DEFAULT NULL,
  `FromName` varchar(100) CHARACTER SET utf8 DEFAULT NULL,
  `toEmail` varchar(100) CHARACTER SET utf8 DEFAULT NULL,
  `Date` datetime DEFAULT NULL,
  `Subject` varchar(2000) DEFAULT NULL,
  `Message` longtext,
  `Attachment` varchar(1000) CHARACTER SET utf8 DEFAULT NULL,
  `Status` int(11) DEFAULT '0',
  `users_id` int(10) DEFAULT '0',
  PRIMARY KEY (`idemail`),
  KEY `fk_email_users1_idx` (`users_id`),
  CONSTRAINT `fk_email_users1` FOREIGN KEY (`users_id`) REFERENCES `users` (`user_id`) ON DELETE NO ACTION ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `email`
--

/*!40000 ALTER TABLE `email` DISABLE KEYS */;
INSERT INTO `email` (`idemail`,`FromEmail`,`FromName`,`toEmail`,`Date`,`Subject`,`Message`,`Attachment`,`Status`,`users_id`) VALUES 
 (5,'info@fhumanes.com','Fernando Humanes','fhumanes.pruebas@gmail.com','2020-10-01 20:19:36','Prueba de adjuntos','<html>\r\n  <head>\r\n\r\n    <meta http-equiv=\"content-type\" content=\"text/html; charset=UTF-8\">\r\n  </head>\r\n  <body>\r\n    <p class=\"summary\"><span class=\"seoSummary\"><strong>HTML</strong>\r\n        (Lenguaje de marcado de hipertexto) es el más básico componente\r\n        de la Web. Define el significado y la estructura del contenido\r\n        web. Además de HTML, se utilizan otras tecnologías generalmente\r\n        para describir la apariencia/presentación de una página web (<a\r\n          href=\"https://developer.mozilla.org/es/docs/Web/CSS\">CSS</a>)\r\n        o la funcionalidad/comportamiento (<a\r\n          href=\"https://developer.mozilla.org/es/docs/Web/JavaScript\">JavaScript</a>.</span></p>\r\n    <p>\"Hipertexto\" se refiere a enlaces que conectan páginas web entre\r\n      sí, ya sea dentro de un único sitio web o entre sitios web. Los\r\n      enlaces son un aspecto fundamental de la Web. Al cargar contenido\r\n      en Internet y vincularlo a páginas creadas por otras personas, te\r\n      conviertes en un participante activo en la «<em>World Wide Web</em>».</p>\r\n    <p>HTML utiliza \"marcado\" para etiquetar texto, imágenes y otro\r\n      contenido para mostrarlo en un navegador web. El marcado HTML\r\n      incluye \"elementos\" especiales como <a\r\n        href=\"https://developer.mozilla.org/es/docs/Web/HTML/Elemento/head\"\r\n        title=\"El elemento HTML &lt;head&gt; provee información general\r\n        (metadatos) acerca del documento, incluyendo su título y enlaces\r\n        a scripts y hojas de estilos.\"><code>&lt;head&gt;</code></a>, <a\r\nhref=\"https://developer.mozilla.org/es/docs/Web/HTML/Elemento/title\"\r\n        title=\"La documentación acerca de este tema no ha sido escrita\r\n        todavía . ¡Por favor considera contribuir !\"><code>&lt;title&gt;</code></a>,\r\n      <a\r\n        href=\"https://developer.mozilla.org/es/docs/Web/HTML/Elemento/body\"\r\n        title=\"El elemento &lt;body&gt; de HTML representa el contenido\r\n        de un documento HTML. Solo puede haber un elemento &lt;body&gt;\r\n        en un documento.\"><code>&lt;body&gt;</code></a>, <a\r\n        href=\"https://developer.mozilla.org/es/docs/Web/HTML/Elemento/header\"\r\n        title=\"El elemento de HTML Header (&lt;header&gt;) representa un\r\n        grupo de ayudas introductorias o de navegación. Puede contener\r\n        algunos elementos de encabezado, así como también un logo,\r\n        un formulario de búsqueda, un nombre de autor y otros\r\n        componentes.\"><code>&lt;header&gt;</code></a>, <a\r\n        href=\"https://developer.mozilla.org/es/docs/Web/HTML/Elemento/footer\"\r\n        title=\"El Elemento HTML Footer (&lt;footer&gt;) representa un\r\n        pie de página para el contenido de sección más cercano o el\r\n        elemento  raíz de sección (p.e, su ancestro mas\r\ncercano &lt;article&gt;, &lt;aside&gt;, &lt;nav&gt;, &lt;section&gt;,&lt;blockquote&gt;, &lt;body&gt;, &lt;details&gt;, &lt;fieldset&gt;, &lt;figure&gt;, &lt;td&gt;).\r\n        Un pie de página típicamente contiene información acerca de el\r\n        autor de la sección, datos de derechos de autor o enlaces a\r\n        documentos relacionados.\"><code>&lt;footer&gt;</code></a>, <a\r\n        href=\"https://developer.mozilla.org/es/docs/Web/HTML/Elemento/article\"\r\n        title=\"El Elemento article de HTML (&lt;article&gt;) representa\r\n        una composición auto-contenida en un documento, página, una\r\n        aplicación o en el sitio, que se destina a distribuir de forma\r\n        independiente o reutilizable, por ejemplo, en la indicación.\r\n        Podría ser un mensaje en un foro, un artículo de una revista o\r\n        un periódico, una entrada de blog, un comentario de un usuario,\r\n        un widget interactivo o gadget, o cualquier otro elemento\r\n        independiente del contenido.\"><code>&lt;article&gt;</code></a>,\r\n      <a\r\n        href=\"https://developer.mozilla.org/es/docs/Web/HTML/Elemento/section\"\r\n        title=\"El elemento de HTML section (&lt;section&gt;) representa\r\n        una sección genérica de un documento. Sirve para determinar qué\r\n        contenido corresponde a qué parte de un esquema. Piensa en el\r\n        esquema como en el índice de contenido de un libro; un tema\r\n        común y subsecciones relacionadas.  Es, por lo tanto, una\r\n        etiquéta semántica. Su funcionalidad principal es estructurar\r\n        semánticamente un documento a la hora de ser representado por\r\n        parte de un agente usuario. Por ejemplo, un agente de usuario\r\n        que represente el documento en voz, podría exponer al usuario el\r\n        índice de contenido por niveles para navegar rápidamente por las\r\n        distintas partes.\"><code>&lt;section&gt;</code></a>, <a\r\n        href=\"https://developer.mozilla.org/es/docs/Web/HTML/Elemento/p\"\r\n        title=\"El elemento p (párrafo) es el apropiado para distribuir\r\n        el texto en párrafos.\"><code>&lt;p&gt;</code></a>, <a\r\n        href=\"https://developer.mozilla.org/es/docs/Web/HTML/Elemento/div\"\r\n        title=\"div de &quot;division&quot; -división . Sirve para crear\r\n        secciones o agrupar contenidos.\"><code>&lt;div&gt;</code></a>, <a\r\nhref=\"https://developer.mozilla.org/es/docs/Web/HTML/Elemento/span\"\r\n        title=\"span - abarcar. Es un contenedor en línea. Sirve para\r\n        aplicar estilo al texto o agrupar elementos en línea.\"><code>&lt;span&gt;</code></a>,\r\n      <a\r\n        href=\"https://developer.mozilla.org/es/docs/Web/HTML/Elemento/img\"\r\n        title=\"&lt;img&gt;\"><code>&lt;img&gt;</code></a>, <a\r\n        href=\"https://developer.mozilla.org/es/docs/Web/HTML/Elemento/aside\"\r\n        title=\"El elemento HTML &lt;aside&gt; representa una sección de\r\n        una página que consiste en contenido que está indirectamente\r\n        relacionado con el contenido principal del documento. Estas\r\n        secciones son a menudo representadas como barras laterales o\r\n        como inserciones y contienen una explicación al margen como una\r\n        definición de glosario, elementos relacionados indirectamente,\r\n        como publicidad, la biografía del autor, o en aplicaciones web,\r\n        la información de perfil o enlaces a blogs relacionados.\"><code>&lt;aside&gt;</code></a>,\r\n      <a\r\n        href=\"https://developer.mozilla.org/es/docs/Web/HTML/Elemento/audio\"\r\n        title=\"El elemento audio se usa para insertar contenido de audio\r\n        en un documento HTML o XHTML. El elemento audio se agregó como\r\n        parte de HTML 5.\"><code>&lt;audio&gt;</code></a>, <a\r\n        href=\"https://developer.mozilla.org/es/docs/Web/HTML/Elemento/canvas\"\r\n        title=\"El elemento HTML canvas (&lt;canvas&gt;) se puede\r\n        utilizar para dibujar gráficos a través de secuencias de\r\n        comandos (por lo general JavaScript ). Por ejemplo, puede usarse\r\n        para dibujar gráficos, hacer composiciones de fotos o incluso\r\n        realizar animaciones.\"><code>&lt;canvas&gt;</code></a>, <a\r\n        href=\"https://developer.mozilla.org/es/docs/Web/HTML/Elemento/datalist\"\r\n        title=\"El elemento HTML &lt;datalist&gt; contiene un conjunto de\r\n        elementos &lt;option&gt; que representan los valores disponibles\r\n        para otros controles.\"><code>&lt;datalist&gt;</code></a>, <a\r\n        href=\"https://developer.mozilla.org/es/docs/Web/HTML/Elemento/details\"\r\n        title=\"El elemento HTML Details &lt;details&gt; es usado como un\r\n        widget de revelación a través del cual el usuario puede obtener\r\n        información adicional .\"><code>&lt;details&gt;</code></a>, <a\r\n        href=\"https://developer.mozilla.org/es/docs/Web/HTML/Elemento/embed\"\r\n        title=\"El Elemento HTML Embed ( &lt;embed&gt; ) representa un\r\n        punto de integración para una aplicación externa o de contenido\r\n        interactivo (en otras palabras, un plug-in).\"><code>&lt;embed&gt;</code></a>,\r\n      <a\r\n        href=\"https://developer.mozilla.org/es/docs/Web/HTML/Elemento/nav\"\r\n        title=\"El elemento HTML &lt;nav&gt; representa una sección de\r\n        una página cuyo propósito es proporcionar enlaces de navegación,\r\n        ya sea dentro del documento actual o a otros documentos.\r\n        Ejemplos comunes de secciones de navegación son menús, tablas de\r\n        contenido e índices.\"><code>&lt;nav&gt;</code></a>, <a\r\n        class=\"new\"\r\n        href=\"https://developer.mozilla.org/es/docs/Web/HTML/Elemento/output\"\r\n        rel=\"nofollow\" title=\"La documentación acerca de este tema no ha\r\n        sido escrita todavía . ¡Por favor considera contribuir !\"><code>&lt;output&gt;</code></a>,\r\n      <a\r\n        href=\"https://developer.mozilla.org/es/docs/Web/HTML/Elemento/progress\"\r\n        title=\"La etiqueta HTML &lt;progress&gt; se utiliza para\r\n        visualizar el progreso de una tarea. Aunque los detalles de como\r\n        se muestran depende directamente del navegador que utiliza el\r\n        cliente, aunque básicamente aparece una barra de progreso.\"><code>&lt;progress&gt;</code></a>,\r\n      <a\r\n        href=\"https://developer.mozilla.org/es/docs/Web/HTML/Elemento/video\"\r\n        title=\"El elemento video se utiliza para incrustar vídeos en un\r\n        documento HTML o XHTML.\"><code>&lt;video&gt;</code></a>, <a\r\n        href=\"https://developer.mozilla.org/es/docs/Web/HTML/Elemento/ul\"\r\n        title=\"ul de &quot;unordered list&quot; -lista no ordenada .\r\n        crea una lista no ordenada.\"><code>&lt;ul&gt;</code></a>, <a\r\n        href=\"https://developer.mozilla.org/es/docs/Web/HTML/Elemento/ol\"\r\n        title=\"El elemento ol permite definir listas o viñetas ordenadas\r\n        (“Ordered List”), bien con numeración o alfabéticamente.\"><code>&lt;ol&gt;</code></a>,\r\n      <a\r\n        href=\"https://developer.mozilla.org/es/docs/Web/HTML/Elemento/li\"\r\n        title=\"La documentación acerca de este tema no ha sido escrita\r\n        todavía . ¡Por favor considera contribuir !\"><code>&lt;li&gt;</code></a>\r\n      y muchos otros.</p>\r\n    <p>Un elemento HTML se distingue de otro texto en un documento\r\n      mediante \"etiquetas\", que consisten en el nombre del elemento\r\n      rodeadas por \"<code>&lt;</code>\" y \"<code>&gt;</code>\". El nombre\r\n      de un elemento dentro de una etiqueta no distingue entre\r\n      mayúsculas y minúsculas. Es decir, se puede escribir en\r\n      mayúsculas, minúsculas o una mezcla. Por ejemplo, la etiqueta <code>&lt;title&gt;</code>\r\n      se puede escribir como <code>&lt;Title&gt;</code>, <code>&lt;TITLE&gt;</code>\r\n      o de cualquier otra forma.</p>\r\n    <p>Los siguientes artículos pueden ayudarte a obtener más\r\n      información sobre HTML.</p>\r\n  <div id=\"DAB4FAD8-2DD7-40BB-A1B8-4E2AA1F9FDF2\"><br /> <table style=\"border-top: 1px solid #D3D4DE;\">\r\n	<tr>\r\n      <td style=\"width: 55px; padding-top: 18px;\"><a href=\"http://www.avg.com/email-signature?utm_medium=email&utm_source=link&utm_campaign=sig-email&utm_content=emailclient\" target=\"_blank\"><img src=\"https://ipmcdn.avast.com/images/icons/icon-envelope-tick-green-avg-v1.png\" alt=\"\"  width=\"46\" height=\"29\" style=\"width: 46px; height: 29px;\" /></a></td>\r\n		<td style=\"width: 470px; padding-top: 17px; color: #41424e; font-size: 13px; font-family: Arial, Helvetica, sans-serif; line-height: 18px;\">Libre de virus. <a href=\"http://www.avg.com/email-signature?utm_medium=email&utm_source=link&utm_campaign=sig-email&utm_content=emailclient\" target=\"_blank\" style=\"color: #4453ea;\">www.avg.com</a> 		</td>\r\n	</tr>\r\n</table>\r\n<a href=\"#DAB4FAD8-2DD7-40BB-A1B8-4E2AA1F9FDF2\" width=\"1\" height=\"1\"> </a></div></body>\r\n</html>','[{\"name\":\"files\\/1602406429_manual_APP.pdf\",\"usrName\":\"manual APP.pdf\",\"size\":448024,\"type\":\"application\\/pdf\",\"searchStr\":\"manual APP.pdf,!:sStrEnd\"},{\"name\":\"files\\/1602406429_Manuales.docx\",\"usrName\":\"Manuales.docx\",\"size\":772892,\"type\":\"application\\/octet-stream\",\"searchStr\":\"Manuales.docx,!:sStrEnd\"},{\"name\":\"files\\/1602406429_manual_APP.docx\",\"usrName\":\"manual APP.docx\",\"size\":555876,\"type\":\"application\\/octet-stream\",\"searchStr\":\"manual APP.docx,!:sStrEnd\"},{\"name\":\"files\\/1602406429_pdf_open_parameters.pdf\",\"usrName\":\"pdf_open_parameters.pdf\",\"size\":113262,\"type\":\"application\\/pdf\",\"searchStr\":\"pdf_open_parameters.pdf,!:sStrEnd\"}]',2,0),
 (6,'info@fhumanes.com','Fernando Humanes','fhumanes.pruebas@gmail.com','2020-10-01 19:11:41','Esto es una prueba para ver el funcionamiento','<html>\r\n  <head>\r\n\r\n    <meta http-equiv=\"content-type\" content=\"text/html; charset=UTF-8\">\r\n  </head>\r\n  <body>\r\n    <p><span class=\"short_text\" id=\"result_box\" lang=\"es\"><span>Aquí\r\n          está una lista completa de</span></span> tipos de MIME,\r\n      asociados por tipo de documentos y  ordenados por su extensión\r\n      común.</p>\r\n    <p>Dos tipos primarios de MIME son importantes para el rol de tipos\r\n      por defecto:</p>\r\n    <ul>\r\n      <li><code>text/plain</code> es el valor por defecto para los\r\n        archivos textuales. Un archivo textual debe ser legible y no\r\n        puede contener datos binarios.</li>\r\n      <li><code>application/octet-stream</code> es el valor por defecto\r\n        para todos los demás casos. Un tipo de archivo desconocido debe\r\n        usar este tipo. Los navegadores tienen un cuidado particular\r\n        cuando manipulan estos archivos, tratando de proteger al usuario\r\n        previéndo comportamientos peligrosos.</li>\r\n    </ul>\r\n    <p>IANA es el registro oficial de los tipos de media MIME y mantiene\r\n      una <a class=\"external\"\r\n        href=\"http://www.iana.org/assignments/media-types/media-types.xhtml\"\r\n        rel=\"noopener\">lista oficial de todos los tipos de MIME</a>.\r\n      Esta tabla, lista algunos de los tipos de MIME importantes para la\r\n      web:</p>\r\n    <p><br>\r\n    </p>\r\n    <p>Fernando<br>\r\n    </p>\r\n  <div id=\"DAB4FAD8-2DD7-40BB-A1B8-4E2AA1F9FDF2\"><br /> <table style=\"border-top: 1px solid #D3D4DE;\">\r\n	<tr>\r\n      <td style=\"width: 55px; padding-top: 18px;\"><a href=\"http://www.avg.com/email-signature?utm_medium=email&utm_source=link&utm_campaign=sig-email&utm_content=emailclient\" target=\"_blank\"><img src=\"https://ipmcdn.avast.com/images/icons/icon-envelope-tick-green-avg-v1.png\" alt=\"\"  width=\"46\" height=\"29\" style=\"width: 46px; height: 29px;\" /></a></td>\r\n		<td style=\"width: 470px; padding-top: 17px; color: #41424e; font-size: 13px; font-family: Arial, Helvetica, sans-serif; line-height: 18px;\">Libre de virus. <a href=\"http://www.avg.com/email-signature?utm_medium=email&utm_source=link&utm_campaign=sig-email&utm_content=emailclient\" target=\"_blank\" style=\"color: #4453ea;\">www.avg.com</a> 		</td>\r\n	</tr>\r\n</table>\r\n<a href=\"#DAB4FAD8-2DD7-40BB-A1B8-4E2AA1F9FDF2\" width=\"1\" height=\"1\"> </a></div></body>\r\n</html>','[{\"name\":\"files\\/1602406432_Guía_2.docx\",\"usrName\":\"Guía 2.docx\",\"size\":238263,\"type\":\"application\\/octet-stream\",\"searchStr\":\"Guía 2.docx,!buho invernal.jpg,!:sStrEnd\"},{\"name\":\"files\\/buho invernal_zey2njpj.jpg\",\"usrName\":\"buho invernal.jpg\",\"size\":328465,\"type\":\"image\\/jpeg\"}]',0,0),
 (7,'fernandohumanes@gmail.com','Fernando Humanes','fhumanes.pruebas@gmail.com','2020-09-24 18:06:07','Pruebas de IMAP','<html>\r\n  <head>\r\n\r\n    <meta http-equiv=\"content-type\" content=\"text/html; charset=UTF-8\">\r\n  </head>\r\n  <body>\r\n    <p><code><span class=\"html\">If you are having difficulty compiling\r\n          on netbsd from source and want imap support then you should\r\n          know that the c-client library is compiled with kerberos\r\n          support.  Unfortunately gssapi_krb5 and k5crypto is not on the\r\n          system (or at least wasn\'t for me).  I didn\'t have\r\n          administrative level access to add these libraries so I had to\r\n          do the following.  I still have to test that it worked 100%\r\n          but at least it compiled without complaining.<br>\r\n          <br>\r\n          Comment the following segments from the configure script.<br>\r\n          <br>\r\n          Segment 1 -- test for gssapi_krb5 library<br>\r\n          <br>\r\n            case gssapi_krb5 in<br>\r\n            c|c_r|pthread*) ;;<br>\r\n            *)<br>\r\n              if test \"$ext_shared\" = \"yes\"; then<br>\r\n                  IMAP_SHARED_LIBADD=\"$IMAP_SHARED_LIBADD -lgssapi_krb5\"<br>\r\n              else<br>\r\n          <br>\r\n          <br>\r\n            case gssapi_krb5 in<br>\r\n            c|c_r|pthread*) ;;<br>\r\n            *)<br>\r\n                LIBS=\"$LIBS -lgssapi_krb5\"<br>\r\n             ;;<br>\r\n            esac<br>\r\n          <br>\r\n              fi<br>\r\n             ;;<br>\r\n            esac</span></code></p>\r\n  <div id=\"DAB4FAD8-2DD7-40BB-A1B8-4E2AA1F9FDF2\"><br /> <table style=\"border-top: 1px solid #D3D4DE;\">\r\n	<tr>\r\n      <td style=\"width: 55px; padding-top: 18px;\"><a href=\"http://www.avg.com/email-signature?utm_medium=email&utm_source=link&utm_campaign=sig-email&utm_content=emailclient\" target=\"_blank\"><img src=\"https://ipmcdn.avast.com/images/icons/icon-envelope-tick-green-avg-v1.png\" alt=\"\"  width=\"46\" height=\"29\" style=\"width: 46px; height: 29px;\" /></a></td>\r\n		<td style=\"width: 470px; padding-top: 17px; color: #41424e; font-size: 13px; font-family: Arial, Helvetica, sans-serif; line-height: 18px;\">Libre de virus. <a href=\"http://www.avg.com/email-signature?utm_medium=email&utm_source=link&utm_campaign=sig-email&utm_content=emailclient\" target=\"_blank\" style=\"color: #4453ea;\">www.avg.com</a> 		</td>\r\n	</tr>\r\n</table>\r\n<a href=\"#DAB4FAD8-2DD7-40BB-A1B8-4E2AA1F9FDF2\" width=\"1\" height=\"1\"> </a></div></body>\r\n</html>','[]',0,0),
 (8,'fernandohumanes@gmail.com','Fernando Humanes','fhumanes.pruebas@gmail.com','2020-09-24 18:02:57','Ejemplo para probar IMAP','<html>\r\n  <head>\r\n\r\n    <meta http-equiv=\"content-type\" content=\"text/html; charset=UTF-8\">\r\n  </head>\r\n  <body>\r\n    <p>Esto es una<font color=\"#ff0000\"> prueba</font><br>\r\n    </p>\r\n  <div id=\"DAB4FAD8-2DD7-40BB-A1B8-4E2AA1F9FDF2\"><br /> <table style=\"border-top: 1px solid #D3D4DE;\">\r\n	<tr>\r\n      <td style=\"width: 55px; padding-top: 18px;\"><a href=\"http://www.avg.com/email-signature?utm_medium=email&utm_source=link&utm_campaign=sig-email&utm_content=emailclient\" target=\"_blank\"><img src=\"https://ipmcdn.avast.com/images/icons/icon-envelope-tick-green-avg-v1.png\" alt=\"\"  width=\"46\" height=\"29\" style=\"width: 46px; height: 29px;\" /></a></td>\r\n		<td style=\"width: 470px; padding-top: 17px; color: #41424e; font-size: 13px; font-family: Arial, Helvetica, sans-serif; line-height: 18px;\">Libre de virus. <a href=\"http://www.avg.com/email-signature?utm_medium=email&utm_source=link&utm_campaign=sig-email&utm_content=emailclient\" target=\"_blank\" style=\"color: #4453ea;\">www.avg.com</a> 		</td>\r\n	</tr>\r\n</table>\r\n<a href=\"#DAB4FAD8-2DD7-40BB-A1B8-4E2AA1F9FDF2\" width=\"1\" height=\"1\"> </a></div></body>\r\n</html>','[{\"name\":\"files\\/buho invernal_pmg39itc.jpg\",\"usrName\":\"buho invernal.jpg\",\"size\":328465,\"type\":\"image\\/jpeg\",\"searchStr\":\"buho invernal.jpg,!:sStrEnd\"}]',0,5),
 (10,'fernandohumanes@gmail.com','Fernando Humanes','fhumanes.pruebas@gmail.com','2020-10-02 12:28:56','Fwd: ? ¡Arrancan los Días Naranjas! ? ¡OFERTONES OTOÑALES!','<html>\r\n  <head>\r\n\r\n    <meta http-equiv=\"content-type\" content=\"text/html; charset=UTF-8\">\r\n  </head>\r\n  <body>\r\n    <p><br>\r\n    </p>\r\n    <div class=\"moz-forward-container\"><br>\r\n      <br>\r\n      -------- Mensaje reenviado --------\r\n      <table class=\"moz-email-headers-table\" cellspacing=\"0\"\r\n        cellpadding=\"0\" border=\"0\">\r\n        <tbody>\r\n          <tr>\r\n            <th valign=\"BASELINE\" nowrap=\"nowrap\" align=\"RIGHT\">Asunto:\r\n            </th>\r\n            <td>? ¡Arrancan los Días Naranjas! ? ¡OFERTONES OTOÑALES!</td>\r\n          </tr>\r\n          <tr>\r\n            <th valign=\"BASELINE\" nowrap=\"nowrap\" align=\"RIGHT\">Fecha: </th>\r\n            <td>Fri, 02 Oct 2020 07:45:37 +0000 (UTC)</td>\r\n          </tr>\r\n          <tr>\r\n            <th valign=\"BASELINE\" nowrap=\"nowrap\" align=\"RIGHT\">De: </th>\r\n            <td>PcComponentes <a class=\"moz-txt-link-rfc2396E\" href=\"mailto:noreply@pccomponentes.com\">&lt;noreply@pccomponentes.com&gt;</a></td>\r\n          </tr>\r\n          <tr>\r\n            <th valign=\"BASELINE\" nowrap=\"nowrap\" align=\"RIGHT\">Responder\r\n              a: </th>\r\n            <td><a class=\"moz-txt-link-abbreviated\" href=\"mailto:creaticket@pccomponentes.com\">creaticket@pccomponentes.com</a></td>\r\n          </tr>\r\n          <tr>\r\n            <th valign=\"BASELINE\" nowrap=\"nowrap\" align=\"RIGHT\">Para: </th>\r\n            <td><a class=\"moz-txt-link-abbreviated\" href=\"mailto:fernandohumanes@gmail.com\">fernandohumanes@gmail.com</a></td>\r\n          </tr>\r\n        </tbody>\r\n      </table>\r\n      <br>\r\n      <br>\r\n      <!--<![endif]-->\r\n      <!--[if gte mso 9]><xml>\r\n<o:OfficeDocumentSettings>\r\n<o:AllowPNG/>\r\n<o:PixelsPerInch>96</o:PixelsPerInch>\r\n</o:OfficeDocumentSettings>\r\n</xml><![endif]-->\r\n      <meta content=\"text/html; charset=UTF-8\" http-equiv=\"Content-Type\">\r\n      <meta content=\"width=device-width\" name=\"viewport\">\r\n      <meta name=\"subject\" content=\"? ¡Arrancan los Días Naranjas! ?\r\n        ¡OFERTONES OTOÑALES!\">\r\n      <meta name=\"author\"\r\n        content=\"PcComponentes&lt;noreply@pccomponentes.com&gt;\">\r\n      <!--[if !mso]><!-->\r\n      <meta content=\"IE=edge\" http-equiv=\"X-UA-Compatible\">\r\n      <!--<![endif]-->\r\n      <title>? Hasta -25% con FINANCIACIÓN al 0% ?</title>\r\n      <style type=\"text/css\">\r\np {\r\nmargin: 0;\r\n}.cn_table {\r\nborder-collapse: collapse;\r\ntable-layout: fixed;\r\n}* {\r\nline-height: inherit;\r\n}a[x-apple-data-detectors=true] {\r\ncolor: inherit !important;\r\ntext-decoration: none !important;\r\n}.ie-browser .col{\r\ndisplay: table-cell;\r\nfloat: none !important;\r\nvertical-align: top;\r\n}.block-grid {\r\nwidth: 600px !important;\r\n}\r\n.block-grid .inner-block-grid{\r\nborder-collapse: collapse;\r\ndisplay: table;\r\nwidth: 100%;\r\ntable-layout: fixed;\r\n}\r\n.block-grid .col {\r\ndisplay: table-cell;\r\nvertical-align: top;\r\n}\r\n.block-grid .width-100 {\r\nwidth: 600px !important;\r\n}\r\n.block-grid .width-75 {\r\nwidth: 450px !important;\r\n}\r\n.block-grid .width-67 {\r\nwidth: 402px !important;\r\n}\r\n.block-grid .width-50 {\r\nwidth: 300px !important;\r\n}\r\n.block-grid .width-34 {\r\nwidth: 204px !important;\r\n}\r\n.block-grid .width-33 {\r\nwidth: 198px !important;\r\n}\r\n.block-grid .width-25 {\r\nwidth: 150px !important;\r\n}\r\n.block-grid .width-20 {\r\nwidth: 120px !important;\r\n}\r\n.block-grid .width-17 {\r\nwidth: 99px !important;\r\n}\r\ndiv.cn_desktop-hidden, div.cn_desktop-hidden.cn_mobile-hidden {\r\ndisplay: none !important;\r\n}\r\ndiv.cn_mobile-hidden {\r\ndisplay: inherit !important;\r\n}@media (max-width: 599px) {\r\n.block-grid {\r\nwidth: calc(100% - 40px) !important;\r\n}\r\n.block-grid .responsive-width-100 {\r\nmax-width: 100% !important;\r\nwidth: 100% !important;\r\n}\r\n.block-grid .responsive-width-75 {\r\nmax-width: 75% !important;\r\nwidth: 75% !important;\r\n}\r\n.block-grid .responsive-width-67 {\r\nmax-width: 67% !important;\r\nwidth: 67% !important;\r\n}\r\n.block-grid .responsive-width-50 {\r\nmax-width: 50% !important;\r\nwidth: 50% !important;\r\n}\r\n.block-grid .responsive-width-34 {\r\nmax-width: 34% !important;\r\nwidth: 34% !important;\r\n}\r\n.block-grid .responsive-width-33 {\r\nmax-width: 33% !important;\r\nwidth: 33% !important;\r\n}\r\n.block-grid .responsive-width-25 {\r\nmax-width: 25% !important;\r\nwidth: 25% !important;\r\n}\r\n.block-grid .responsive-width-20 {\r\nmax-width: 20% !important;\r\nwidth: 20% !important;\r\n}\r\n.block-grid .responsive-width-17 {\r\nmax-width: 16.66% !important;\r\nwidth: 16.66% !important;\r\n}\r\n.block-grid .col > div {\r\nmargin: 0 auto;\r\n}\r\nimg.fullwidth {\r\nmax-width: 100% !important;\r\n}\r\ndiv.cn_mobile-hidden {\r\ndisplay: none !important;\r\n}\r\ndiv.cn_desktop-hidden {\r\ndisplay: inherit !important;\r\n}\r\n}\r\n</style>\r\n      <style type=\"text/css\">\r\n    a {\r\n        color: #333;\r\n        text-decoration: none;\r\n    }\r\n\r\n    a:hover {\r\n        color: #666;\r\n    }\r\n    @media screen and (min-width: 600px) {\r\n        .main-logo {\r\n            height: 50px !important;\r\n            text-align: left !important;\r\n            padding-bottom: 0px;\r\n        }\r\n        .c-main-menu {\r\n            height: 50px !important;\r\n            text-align: right !important;\r\n        }\r\n        .c-main-menu__secondary {\r\n            display: inline !important;\r\n        }\r\n  .c-newsletter-header__tagline {\r\n            display: block !important;\r\n        }\r\n        .c-newsletter-header__conditional-text {\r\n            display: inline-block !important;\r\n        }\r\n        .c-discover-btn {\r\n            padding: 0px 16px !important; \r\n        }\r\n        .c-newsletter-header__image-cell {\r\n            padding: 16px 8px !important;\r\n        }\r\n        .c-newsletter-header__button-cell {\r\n            padding: 16px 8px !important;\r\n        }\r\n    }\r\n</style><!--[if mso]>\r\n<body class=\"mso-container\" style=\"background-color:; font-family: \'Open Sans\', \'Helvetica Neue\', Helvetica, Arial, sans-serif;\">\r\n<![endif]-->\r\n      <!--[if !mso]><!-->\r\n      <!--<![endif]-->\r\n      <span class=\"cn_preheader\"\r\nstyle=\"display:none;font-size:1px;color:#333333;line-height:1px;max-height:0px;max-width:0px;opacity:0;overflow:hidden;\">?\r\n        Hasta -25% con FINANCIACIÓN al 0% ?</span>\r\n      <img alt=\"\"\r\nsrc=\"https://cl1-api.connectif.cloud/content/track-open?entityId=5b3f24199b6aa91b64d6c72d&amp;userId=5b223ad9ec0d680e78979fdf&amp;contentId=5f758c2c27ba877f7580dd32&amp;contentTypeId=email&amp;entityEmail=fernandohumanes%40gmail.com&amp;contentName=DIASNARANJAS-2020-ES%20-%20Inicio%20campa%C3%B1a&amp;workflowDefinitionId=5f758cb627ba877f758107f7&amp;sendUuid=ad49774a-66f1-430c-8104-9c575ff939fa\"\r\n        moz-do-not-send=\"true\">\r\n      <div class=\"nl-container\" style=\"min-width: 320px;Margin: 0 auto;\">\r\n        <!--[if (mso)|(IE)]><table class=\"cn_table\" width=\"100%\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tr><td align=\"center\" style=\"background-color: ;\"><![endif]-->\r\n        <div style=\"background-color:transparent;\">\r\n          <div class=\"block-grid\" style=\"Margin: 0 auto;max-width:\r\n            600px;width: 600px;overflow-wrap: break-word;word-wrap:\r\n            break-word;word-break: break-word;background-color:\r\n            #ffffff;\">\r\n            <div class=\"inner-block-grid\"\r\n              style=\"border-collapse:collapse;display: table;width:\r\n              100%;table-layout: fixed;\">\r\n              <!--[if (mso)|(IE)]><table class=\"cn_table\" width=\"100%\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tr><td style=\"background-color:;\" align=\"center\"><table class=\"cn_table\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width: 600px;\"><tr class=\"layout-full-width\" style=\"background-color:transparent;\"><![endif]-->\r\n              <!--[if (mso)|(IE)]><td bgcolor=\"#ffffff\" align=\"center\" width=\"600\" style=\" width:600px; padding-right: 0px; padding-left: 0px; border-top: 0px solid transparent; border-left: 0px solid transparent; border-bottom: 0px solid transparent; border-right: 0px solid transparent;\" valign=\"top\"><![endif]-->\r\n              <div class=\"col width-100 responsive-width-100\"\r\n                style=\"Float: left;background-color:\r\n                transparent;display: table-cell;vertical-align:\r\n                top;width: 600px;\">\r\n                <div style=\"background-color: transparent;\">\r\n                  <div style=\"width: 100% !important;\">\r\n                    <div align=\"center\">\r\n                      <!--[if !mso]><!-->\r\n                      <div style=\"margin-right: 8px;margin-left: 8px;\"\r\n                        align=\"center\">\r\n                        <!--<![endif]-->\r\n                        <!--[if mso]>\r\n<table class=\"cn_table\" width=\"100%\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tr><td style=\"padding-right: 8px;padding-left: 8px;\" align=\"center\">\r\n<![endif]-->\r\n                        <div class=\"c-see-navigator\" style=\"font-size:\r\n                          11px; line-height: 20px; text-align: right;\r\n                          font-family: Open Sans, Arial, Sans Serif;\r\n                          color: #333;\"> <a\r\nhref=\"https://cl1-api.connectif.cloud/content/track-click/v1/eyJ1aSI6IjViMjIzYWQ5ZWMwZDY4MGU3ODk3OWZkZiIsImVpIjoiNWIzZjI0MTk5YjZhYTkxYjY0ZDZjNzJkIiwiZWUiOiJmZXJuYW5kb2h1bWFuZXNAZ21haWwuY29tIiwiY2kiOiI1Zjc1OGMyYzI3YmE4NzdmNzU4MGRkMzIiLCJjbiI6IkRJQVNOQVJBTkpBUy0yMDIwLUVTIC0gSW5pY2lvIGNhbXBhw7FhIiwibHUiOiJodHRwczovL2NsMS1hcGkuY29ubmVjdGlmLmNsb3VkL2NvbnRlbnQvdmlldy1pbi1icm93c2VyLzViMjIzYWQ5ZWMwZDY4MGU3ODk3OWZkZi9hZDQ5Nzc0YS02NmYxLTQzMGMtODEwNC05YzU3NWZmOTM5ZmEvQmNQOXZGUGpFOTRRWVVWU0RaZWxjZz09P2VudGl0eUlkPTViM2YyNDE5OWI2YWE5MWI2NGQ2YzcyZCZlbnRpdHlFbWFpbD1mZXJuYW5kb2h1bWFuZXMlNDBnbWFpbC5jb20mY29udGVudElkPTVmNzU4YzJjMjdiYTg3N2Y3NTgwZGQzMiZ3b3JrZmxvd0RlZmluaXRpb25JZD01Zjc1OGNiNjI3YmE4NzdmNzU4MTA3ZjciLCJjdGkiOiJlbWFpbCIsIndkaSI6IjVmNzU4Y2I2MjdiYTg3N2Y3NTgxMDdmNyIsInN1IjoiYWQ0OTc3NGEtNjZmMS00MzBjLTgxMDQtOWM1NzVmZjkzOWZhIiwib2x1IjoiI19fY25fdmlld19pbl9icm93c2VyIiwiY2giOiJCY1A5dkZQakU5NFFZVVZTRFplbGNnPT0ifQ..\"\r\n                            style=\"color: #333;text-decoration: none;\"\r\n                            moz-do-not-send=\"true\">Ver en navegador </a>\r\n                        </div>\r\n                        <!--[if mso]>\r\n</td></tr></table>\r\n<![endif]-->\r\n                        <!--[if !mso]><!-->\r\n                      </div>\r\n                      <!--<![endif]-->\r\n                    </div>\r\n                  </div>\r\n                </div>\r\n              </div>\r\n              <!--[if (mso)|(IE)]></td><![endif]-->\r\n              <!--[if (mso)|(IE)]></tr></table></td></tr></table><![endif]-->\r\n            </div>\r\n          </div>\r\n        </div>\r\n        <div style=\"background-color:transparent;\">\r\n          <div class=\"block-grid\" style=\"Margin: 0 auto;max-width:\r\n            600px;width: 600px;overflow-wrap: break-word;word-wrap:\r\n            break-word;word-break: break-word;background-color:\r\n            #ffffff;\">\r\n            <div class=\"inner-block-grid\"\r\n              style=\"border-collapse:collapse;display: table;width:\r\n              100%;table-layout: fixed;\">\r\n              <!--[if (mso)|(IE)]><table class=\"cn_table\" width=\"100%\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tr><td style=\"background-color:;\" align=\"center\"><table class=\"cn_table\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width: 600px;\"><tr class=\"layout-full-width\" style=\"background-color:transparent;\"><![endif]-->\r\n              <!--[if (mso)|(IE)]><td bgcolor=\"#ffffff\" align=\"center\" width=\"600\" style=\" width:600px; padding-right: 0px; padding-left: 0px; border-top: 0px solid transparent; border-left: 0px solid transparent; border-bottom: 0px solid transparent; border-right: 0px solid transparent;\" valign=\"top\"><![endif]-->\r\n              <div class=\"col width-100 responsive-width-100\"\r\n                style=\"Float: left;background-color:\r\n                transparent;display: table-cell;vertical-align:\r\n                top;width: 600px;\">\r\n                <div style=\"background-color: transparent;\">\r\n                  <div style=\"width: 100% !important;\">\r\n                    <div align=\"center\">\r\n                      <!--[if !mso]><!-->\r\n                      <div style=\"margin-right: 0px;margin-left: 0px;\"\r\n                        align=\"center\">\r\n                        <!--<![endif]-->\r\n                        <!--[if mso]>\r\n<table class=\"cn_table\" width=\"100%\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tr><td style=\"padding-right: 0px;padding-left: 0px;\" align=\"center\">\r\n<![endif]-->\r\n                        <a\r\nhref=\"https://cl1-api.connectif.cloud/content/track-click/v1/eyJ1aSI6IjViMjIzYWQ5ZWMwZDY4MGU3ODk3OWZkZiIsImVpIjoiNWIzZjI0MTk5YjZhYTkxYjY0ZDZjNzJkIiwiZWUiOiJmZXJuYW5kb2h1bWFuZXNAZ21haWwuY29tIiwiY2kiOiI1Zjc1OGMyYzI3YmE4NzdmNzU4MGRkMzIiLCJjbiI6IkRJQVNOQVJBTkpBUy0yMDIwLUVTIC0gSW5pY2lvIGNhbXBhw7FhIiwibHUiOiJodHRwczovL3d3dy5wY2NvbXBvbmVudGVzLmNvbS9wY2RheXM_dXRtX2NvbnRlbnQ9bG9nbyZ1dG1fY2FtcGFpZ249ZGlhcy1uYXJhbmphcy0yMDIwLUVTJnV0bV9zb3VyY2U9Y29ubmVjdGlmJnV0bV9tZWRpdW09ZW1haWwiLCJjdGkiOiJlbWFpbCIsIndkaSI6IjVmNzU4Y2I2MjdiYTg3N2Y3NTgxMDdmNyIsInN1IjoiYWQ0OTc3NGEtNjZmMS00MzBjLTgxMDQtOWM1NzVmZjkzOWZhIiwib2x1IjoiaHR0cHM6Ly93d3cucGNjb21wb25lbnRlcy5jb20vcGNkYXlzP3V0bV9jb250ZW50PWxvZ28iLCJjaCI6IkJjUDl2RlBqRTk0UVlVVlNEWmVsY2c9PSJ9\"\r\n                          title=\"PcComponentes\" target=\"_blank\"\r\n                          moz-do-not-send=\"true\">\r\n                          <img alt=\"PcComponentes\"\r\nsrc=\"http://cdn.pccomponentes.com/img/emails/pccomponentes-minilogo-default-mar18.png\"\r\n                            style=\"outline: none;text-decoration:\r\n                            none;-ms-interpolation-mode: bicubic;clear:\r\n                            both;display: block;border: none;height:\r\n                            auto;float: none;vertical-align:top;width:\r\n                            100%;max-width: 112px\" title=\"PcComponentes\"\r\n                            moz-do-not-send=\"true\" width=\"112\"\r\n                            border=\"0\" align=\"middle\">\r\n                        </a>\r\n                        <!--[if mso]>\r\n</td></tr></table>\r\n<![endif]-->\r\n                        <!--[if !mso]><!-->\r\n                      </div>\r\n                      <!--<![endif]-->\r\n                    </div>\r\n                  </div>\r\n                  <div style=\"line-height:16px; font-size:1px\"> </div>\r\n                </div>\r\n                <div style=\"background-color: transparent;\">\r\n                  <div style=\"width: 100% !important;\">\r\n                    <div align=\"center\">\r\n                      <!--[if !mso]><!-->\r\n                      <div style=\"margin-right: 0px;margin-left: 0px;\"\r\n                        align=\"center\">\r\n                        <!--<![endif]-->\r\n                        <!--[if mso]>\r\n<table class=\"cn_table\" width=\"100%\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tr><td style=\"padding-right: 0px;padding-left: 0px;\" align=\"center\">\r\n<![endif]-->\r\n                        <a\r\nhref=\"https://cl1-api.connectif.cloud/content/track-click/v1/eyJ1aSI6IjViMjIzYWQ5ZWMwZDY4MGU3ODk3OWZkZiIsImVpIjoiNWIzZjI0MTk5YjZhYTkxYjY0ZDZjNzJkIiwiZWUiOiJmZXJuYW5kb2h1bWFuZXNAZ21haWwuY29tIiwiY2kiOiI1Zjc1OGMyYzI3YmE4NzdmNzU4MGRkMzIiLCJjbiI6IkRJQVNOQVJBTkpBUy0yMDIwLUVTIC0gSW5pY2lvIGNhbXBhw7FhIiwibHUiOiJodHRwczovL3d3dy5wY2NvbXBvbmVudGVzLmNvbS9kaWFzLW5hcmFuamFzP3V0bV9jb250ZW50PXRhcmpldG9uJnV0bV9jYW1wYWlnbj1kaWFzLW5hcmFuamFzLTIwMjAtRVMmdXRtX3NvdXJjZT1jb25uZWN0aWYmdXRtX21lZGl1bT1lbWFpbCIsImN0aSI6ImVtYWlsIiwid2RpIjoiNWY3NThjYjYyN2JhODc3Zjc1ODEwN2Y3Iiwic3UiOiJhZDQ5Nzc0YS02NmYxLTQzMGMtODEwNC05YzU3NWZmOTM5ZmEiLCJvbHUiOiJodHRwczovL3d3dy5wY2NvbXBvbmVudGVzLmNvbS9kaWFzLW5hcmFuamFzP3V0bV9jb250ZW50PXRhcmpldG9uIiwiY2giOiJCY1A5dkZQakU5NFFZVVZTRFplbGNnPT0ifQ..\"\r\n                          title=\"¡Arrancan los Días Naranjas del 2 al 14\r\n                          de octubre, con OFERTAS ALUCINANTES!\"\r\n                          target=\"_blank\" moz-do-not-send=\"true\">\r\n                          <img alt=\"¡Arrancan los Días Naranjas del 2 al\r\n                            14 de octubre, con OFERTAS ALUCINANTES!\"\r\nsrc=\"https://cdn.connectif.cloud/cl1/5b223ad9ec0d680e78979fdf/images/originals/aeaf3ea2-785f-40b7-9bab-c554aaea104d-600x690.png\"\r\n                            style=\"outline: none;text-decoration:\r\n                            none;-ms-interpolation-mode: bicubic;clear:\r\n                            both;display: block;border: none;height:\r\n                            auto;float: none;vertical-align:top;width:\r\n                            100%;max-width: 600px\" title=\"¡Arrancan los\r\n                            Días Naranjas del 2 al 14 de octubre, con\r\n                            OFERTAS ALUCINANTES!\" moz-do-not-send=\"true\"\r\n                            width=\"600\" border=\"0\" align=\"middle\">\r\n                        </a>\r\n                        <!--[if mso]>\r\n</td></tr></table>\r\n<![endif]-->\r\n                        <!--[if !mso]><!-->\r\n                      </div>\r\n                      <!--<![endif]-->\r\n                    </div>\r\n                  </div>\r\n                </div>\r\n                <div style=\"width: 100% !important;\">\r\n                  <!--[if !mso]><!-->\r\n                  <div style=\"margin-right: 0px;margin-left: 0px;\"\r\n                    align=\"center\">\r\n                    <!--<![endif]-->\r\n                    <div style=\"line-height: 20px; font-size:1px\"> </div>\r\n                    <!--[if (mso)|(IE)]>\r\n<table class=\"cn_table\" width=\"100%\" align=\"center\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tr><td style=\"padding-right: 0px;padding-left: 0px;\">\r\n<![endif]-->\r\n                    <div style=\"border-top: 1px solid #cccccc;\r\n                      width:100%; font-size:1px;\"> </div>\r\n                    <!--[if (mso)|(IE)]>\r\n</td></tr></table>\r\n<![endif]-->\r\n                    <div style=\"line-height: 20px; font-size:1px\"> </div>\r\n                    <!--[if !mso]><!-->\r\n                  </div>\r\n                  <!--<![endif]-->\r\n                </div>\r\n              </div>\r\n              <!--[if (mso)|(IE)]></td><![endif]-->\r\n              <!--[if (mso)|(IE)]></tr></table></td></tr></table><![endif]-->\r\n            </div>\r\n          </div>\r\n        </div>\r\n        <div style=\"background-color:transparent;\">\r\n          <div class=\"block-grid\" style=\"Margin: 0 auto;max-width:\r\n            600px;width: 600px;overflow-wrap: break-word;word-wrap:\r\n            break-word;word-break: break-word;background-color:\r\n            #ffffff;\">\r\n            <div class=\"inner-block-grid\"\r\n              style=\"border-collapse:collapse;display: table;width:\r\n              100%;table-layout: fixed;\">\r\n              <!--[if (mso)|(IE)]><table class=\"cn_table\" width=\"100%\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tr><td style=\"background-color:;\" align=\"center\"><table class=\"cn_table\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width: 600px;\"><tr class=\"layout-full-width\" style=\"background-color:transparent;\"><![endif]-->\r\n              <!--[if (mso)|(IE)]><td bgcolor=\"#ffffff\" align=\"center\" width=\"600\" style=\" width:600px; padding-right: 0px; padding-left: 0px; border-top: 0px solid transparent; border-left: 0px solid transparent; border-bottom: 0px solid transparent; border-right: 0px solid transparent;\" valign=\"top\"><![endif]-->\r\n              <div class=\"col width-100 responsive-width-100\"\r\n                style=\"Float: left;background-color:\r\n                transparent;display: table-cell;vertical-align:\r\n                top;width: 600px;\">\r\n                <div style=\"background-color: transparent;\">\r\n                  <div style=\"width: 100% !important;\">\r\n                    <div align=\"center\">\r\n                      <!--[if !mso]><!-->\r\n                      <div style=\"margin-right: 10px;margin-left: 10px;\"\r\n                        align=\"center\">\r\n                        <!--<![endif]-->\r\n                        <!--[if mso]>\r\n<table class=\"cn_table\" width=\"100%\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tr><td style=\"padding-right: 10px;padding-left: 10px;\" align=\"center\">\r\n<![endif]-->\r\n                        <table style=\"width: 100%; table-layout:fixed; \"\r\n                          width=\"100\" cellspacing=\"0\" cellpadding=\"16\"\r\n                          border=\"0\">\r\n                          <tbody>\r\n                            <tr>\r\n                              <td style=\"padding: 32px 16px 16px;\r\n                                vertical-align: bottom; width: 100%;\r\n                                word-break: break-word;\" align=\"center\">\r\n                                <div style=\"font-family: \'Open Sans\',\r\n                                  arial, sans; font-size: 16px;\r\n                                  font-weight: bold; line-height: 1;\r\n                                  text-align: center; color: #444;\">PcComponentes,\r\n                                  tu tienda líder por precio, calidad y\r\n                                  servicio</div>\r\n                              </td>\r\n                            </tr>\r\n                          </tbody>\r\n                        </table>\r\n                        <div width=\"100\" style=\"padding:16px 8px 32px;\">\r\n                          <table style=\"vertical-align: bottom; width:\r\n                            100%; table-layout:fixed;\" cellspacing=\"0\"\r\n                            cellpadding=\"0\" border=\"0\">\r\n                            <tbody>\r\n                              <tr>\r\n                                <td style=\"width: 25%;\" align=\"center\">\r\n                                  <img style=\"border: 0; display: block;\r\n                                    outline: none; text-decoration:\r\n                                    none; width: 24px;\"\r\nsrc=\"http://cdn.pccomponentes.com/img/emails/commons/foot-v3-icon-ship.png\"\r\n                                    alt=\"\" moz-do-not-send=\"true\"\r\n                                    width=\"24\" height=\"auto\">\r\n                                  <div style=\"font-family: \'Open Sans\';\r\n                                    font-size: 12px; line-height: 16px;\r\n                                    text-align: center; color: #444;\">Plazos<br>\r\n                                    de entrega</div>\r\n                                </td>\r\n                                <td style=\"width: 25%;\" align=\"center\">\r\n                                  <img style=\"border: 0; display: block;\r\n                                    outline: none; text-decoration:\r\n                                    none; width: 24px;\"\r\nsrc=\"http://cdn.pccomponentes.com/img/emails/commons/foot-v3-icon-return.png\"\r\n                                    alt=\"\" moz-do-not-send=\"true\"\r\n                                    width=\"24\" height=\"auto\">\r\n                                  <div style=\"font-family: \'Open Sans\';\r\n                                    font-size: 12px; line-height: 16px;\r\n                                    text-align: center; color: #444;\">30\r\n                                    dias de<br>\r\n                                    devolución</div>\r\n                                </td>\r\n                                <td style=\"width: 25%;\" align=\"center\">\r\n                                  <img style=\"border: 0; display: block;\r\n                                    outline: none; text-decoration:\r\n                                    none; width: 24px;\"\r\nsrc=\"http://cdn.pccomponentes.com/img/emails/commons/foot-v3-icon-secure.png\"\r\n                                    alt=\"\" moz-do-not-send=\"true\"\r\n                                    width=\"24\" height=\"auto\">\r\n                                  <div style=\"font-family: \'Open Sans\';\r\n                                    font-size: 12px; line-height: 16px;\r\n                                    text-align: center; color: #444;\">100%<br>\r\n                                    Pago seguro</div>\r\n                                </td>\r\n                                <td style=\"width: 25%;\" align=\"center\">\r\n                                  <img style=\"border: 0; display: block;\r\n                                    outline: none; text-decoration:\r\n                                    none; width: 24px;\"\r\nsrc=\"https://cdn.pccomponentes.com/img/emails/commons/foot-v3-icon-support.png\"\r\n                                    alt=\"\" moz-do-not-send=\"true\"\r\n                                    width=\"24\" height=\"auto\">\r\n                                  <div style=\"font-family: \'Open Sans\';\r\n                                    font-size: 12px; line-height: 16px;\r\n                                    text-align: center; color: #444;\">Atención<br>\r\n                                    al Cliente</div>\r\n                                </td>\r\n                              </tr>\r\n                            </tbody>\r\n                          </table>\r\n                        </div>\r\n                        <div style=\"padding:16px 8px 16px; border-top:\r\n                          solid 2px #e3e3e3; border-bottom: solid 2px\r\n                          #e3e3e3;\">\r\n                          <table style=\"vertical-align: bottom; width:\r\n                            100%;table-layout:fixed;\" cellspacing=\"0\"\r\n                            cellpadding=\"0\" border=\"0\">\r\n                            <tbody>\r\n                              <tr>\r\n                                <td style=\"width: 100%;\" align=\"center\">\r\n                                  <img style=\"padding:8px;\"\r\nsrc=\"http://cdn.pccomponentes.com/img/emails/commons/ssrr-v3-icon-twitter.png\"\r\n                                    alt=\"Twitter de PcComponentes\"\r\n                                    moz-do-not-send=\"true\"> <img\r\n                                    style=\"padding:8px;\"\r\nsrc=\"http://cdn.pccomponentes.com/img/emails/commons/ssrr-v3-icon-facebook.png\"\r\n                                    alt=\"Facebook de PcComponentes\"\r\n                                    moz-do-not-send=\"true\"> <img\r\n                                    style=\"padding:8px;\"\r\nsrc=\"http://cdn.pccomponentes.com/img/emails/commons/ssrr-v3-icon-instagram.png\"\r\n                                    alt=\"Instagram de PcComponentes\"\r\n                                    moz-do-not-send=\"true\"> <img\r\n                                    style=\"padding:8px;\"\r\nsrc=\"http://cdn.pccomponentes.com/img/emails/commons/ssrr-v3-icon-youtube.png\"\r\n                                    alt=\"YouTube de PcComponentes\"\r\n                                    moz-do-not-send=\"true\"> </td>\r\n                              </tr>\r\n                            </tbody>\r\n                          </table>\r\n                        </div>\r\n                        <!--[if mso]>\r\n</td></tr></table>\r\n<![endif]-->\r\n                        <!--[if !mso]><!-->\r\n                      </div>\r\n                      <!--<![endif]-->\r\n                    </div>\r\n                  </div>\r\n                  <div style=\"line-height: 16px; font-size:1px\"> </div>\r\n                </div>\r\n              </div>\r\n              <!--[if (mso)|(IE)]></td><![endif]-->\r\n              <!--[if (mso)|(IE)]></tr></table></td></tr></table><![endif]-->\r\n            </div>\r\n          </div>\r\n        </div>\r\n        <div style=\"background-color:transparent;\">\r\n          <div class=\"block-grid\" style=\"Margin: 0 auto;max-width:\r\n            600px;width: 600px;overflow-wrap: break-word;word-wrap:\r\n            break-word;word-break: break-word;background-color:\r\n            #ffffff;\">\r\n            <div class=\"inner-block-grid\"\r\n              style=\"border-collapse:collapse;display: table;width:\r\n              100%;table-layout: fixed;\">\r\n              <!--[if (mso)|(IE)]><table class=\"cn_table\" width=\"100%\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tr><td style=\"background-color:;\" align=\"center\"><table class=\"cn_table\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width: 600px;\"><tr class=\"layout-full-width\" style=\"background-color:transparent;\"><![endif]-->\r\n              <!--[if (mso)|(IE)]><td bgcolor=\"#ffffff\" align=\"center\" width=\"600\" style=\" width:600px; padding-right: 0px; padding-left: 0px; border-top: 0px solid transparent; border-left: 0px solid transparent; border-bottom: 0px solid transparent; border-right: 0px solid transparent;\" valign=\"top\"><![endif]-->\r\n              <div class=\"col width-100 responsive-width-100\"\r\n                style=\"Float: left;background-color:\r\n                transparent;display: table-cell;vertical-align:\r\n                top;width: 600px;\">\r\n                <div style=\"background-color: transparent;\">\r\n                  <div style=\"line-height: 8px; font-size:1px\"> </div>\r\n                  <div style=\"width: 100% !important;\">\r\n                    <div align=\"center\">\r\n                      <!--[if !mso]><!-->\r\n                      <div style=\"margin-right: 16px;margin-left: 16px;\"\r\n                        align=\"center\">\r\n                        <!--<![endif]-->\r\n                        <!--[if mso]>\r\n<table class=\"cn_table\" width=\"100%\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tr><td style=\"padding-right: 16px;padding-left: 16px;\" align=\"center\">\r\n<![endif]-->\r\n                        <p class=\"default-legal\" style=\"font-size: 9px;\r\n                          line-height: auto; text-align: center; color:\r\n                          #8c8c8c;\"><br>\r\n                          Has recibido este email por estar suscrito a\r\n                          la recepción de correos electrónicos. Si no\r\n                          deseas recibir más comunicaciones de este tipo\r\n                          haz <a\r\nhref=\"https://cl1-api.connectif.cloud/content/track-click/v1/eyJ1aSI6IjViMjIzYWQ5ZWMwZDY4MGU3ODk3OWZkZiIsImVpIjoiNWIzZjI0MTk5YjZhYTkxYjY0ZDZjNzJkIiwiZWUiOiJmZXJuYW5kb2h1bWFuZXNAZ21haWwuY29tIiwiY2kiOiI1Zjc1OGMyYzI3YmE4NzdmNzU4MGRkMzIiLCJjbiI6IkRJQVNOQVJBTkpBUy0yMDIwLUVTIC0gSW5pY2lvIGNhbXBhw7FhIiwibHUiOiJodHRwczovL2NsMS1hcGkuY29ubmVjdGlmLmNsb3VkL2NvbnRlbnQvdW5zdWJzY3JpYmU_ZW50aXR5SWQ9NWIzZjI0MTk5YjZhYTkxYjY0ZDZjNzJkJnVzZXJJZD01YjIyM2FkOWVjMGQ2ODBlNzg5NzlmZGYmY29udGVudElkPTVmNzU4YzJjMjdiYTg3N2Y3NTgwZGQzMiZjb250ZW50VHlwZUlkPWVtYWlsJmVudGl0eUVtYWlsPWZlcm5hbmRvaHVtYW5lcyU0MGdtYWlsLmNvbSZjb250ZW50TmFtZT1ESUFTTkFSQU5KQVMtMjAyMC1FUyUyMC0lMjBJbmljaW8lMjBjYW1wYSVDMyVCMWEmd29ya2Zsb3dEZWZpbml0aW9uSWQ9NWY3NThjYjYyN2JhODc3Zjc1ODEwN2Y3JnNlbmRVdWlkPWFkNDk3NzRhLTY2ZjEtNDMwYy04MTA0LTljNTc1ZmY5MzlmYSZsaW5rVXJsPSUyM19fY25fdW5zdWJzY3JpYmUmb3JpZ2luYWxMaW5rVXJsPSUyM19fY25fdW5zdWJzY3JpYmUmdXRtX2NhbXBhaWduPWRpYXMtbmFyYW5qYXMtMjAyMC1FUyZ1dG1fc291cmNlPWNvbm5lY3RpZiZ1dG1fbWVkaXVtPWVtYWlsIiwiY3RpIjoiZW1haWwiLCJ3ZGkiOiI1Zjc1OGNiNjI3YmE4NzdmNzU4MTA3ZjciLCJzdSI6ImFkNDk3NzRhLTY2ZjEtNDMwYy04MTA0LTljNTc1ZmY5MzlmYSIsIm9sdSI6IiNfX2NuX3Vuc3Vic2NyaWJlIiwiY2giOiJCY1A5dkZQakU5NFFZVVZTRFplbGNnPT0ifQ..\"\r\n                            class=\"stealth-link\" style=\"color: inherit;\r\n                            text-decoration: underline;\"\r\n                            moz-do-not-send=\"true\">clic aquí</a>. Puedes\r\n                          ejercer tus derechos de acceso, rectificación,\r\n                          cancelación u oposición a la siguiente\r\n                          dirección: Avenida de Europa, 2-5, 2-6,\r\n                          Polígono Industrial Las Salinas, 30840, Alhama\r\n                          de Murcia (Murcia).</p>\r\n                        <!--[if mso]>\r\n</td></tr></table>\r\n<![endif]-->\r\n                        <!--[if !mso]><!-->\r\n                      </div>\r\n                      <!--<![endif]-->\r\n                    </div>\r\n                  </div>\r\n                  <div style=\"line-height: 16px; font-size:1px\"> </div>\r\n                </div>\r\n              </div>\r\n              <!--[if (mso)|(IE)]></td><![endif]-->\r\n              <!--[if (mso)|(IE)]></tr></table></td></tr></table><![endif]-->\r\n            </div>\r\n          </div>\r\n        </div>\r\n        <!--[if (mso)|(IE)]></td></tr></table><![endif]-->\r\n      </div>\r\n      <div id=\"DAB4FAD8-2DD7-40BB-A1B8-4E2AA1F9FDF2\"><br>\r\n        <table style=\"border-top: 1px solid #D3D4DE;\">\r\n          <tbody>\r\n            <tr>\r\n              <td style=\"width: 55px; padding-top: 18px;\"><a\r\nhref=\"http://www.avg.com/email-signature?utm_medium=email&amp;utm_source=link&amp;utm_campaign=sig-email&amp;utm_content=emailclient\"\r\n                  target=\"_blank\" moz-do-not-send=\"true\"><img\r\nsrc=\"https://ipmcdn.avast.com/images/icons/icon-envelope-tick-green-avg-v1.png\"\r\n                    alt=\"\" style=\"width: 46px; height: 29px;\"\r\n                    moz-do-not-send=\"true\" width=\"46\" height=\"29\"></a></td>\r\n              <td style=\"width: 470px; padding-top: 17px; color:\r\n                #41424e; font-size: 13px; font-family: Arial, Helvetica,\r\n                sans-serif; line-height: 18px;\">Libre de virus. <a\r\nhref=\"http://www.avg.com/email-signature?utm_medium=email&amp;utm_source=link&amp;utm_campaign=sig-email&amp;utm_content=emailclient\"\r\n                  target=\"_blank\" style=\"color: #4453ea;\"\r\n                  moz-do-not-send=\"true\">www.avg.com</a> </td>\r\n            </tr>\r\n          </tbody>\r\n        </table>\r\n        <a href=\"#DAB4FAD8-2DD7-40BB-A1B8-4E2AA1F9FDF2\" width=\"1\"\r\n          height=\"1\" moz-do-not-send=\"true\"> </a></div>\r\n    </div>\r\n  </body>\r\n</html>','',0,5),
 (11,'fernandohumanes@gmail.com','Fernando Humanes','fhumanes.pruebas@gmail.com','2020-10-02 12:28:32','Fwd: ?¿Qué calzado eliges tú para volver??','<html>\r\n  <head>\r\n\r\n    <meta http-equiv=\"content-type\" content=\"text/html; charset=UTF-8\">\r\n  </head>\r\n  <body>\r\n    <p><br>\r\n    </p>\r\n    <div class=\"moz-forward-container\"><br>\r\n      <br>\r\n      -------- Mensaje reenviado --------\r\n      <table class=\"moz-email-headers-table\" cellspacing=\"0\"\r\n        cellpadding=\"0\" border=\"0\">\r\n        <tbody>\r\n          <tr>\r\n            <th valign=\"BASELINE\" nowrap=\"nowrap\" align=\"RIGHT\">Asunto:\r\n            </th>\r\n            <td>?¿Qué calzado eliges tú para volver??</td>\r\n          </tr>\r\n          <tr>\r\n            <th valign=\"BASELINE\" nowrap=\"nowrap\" align=\"RIGHT\">Fecha: </th>\r\n            <td>Fri, 02 Oct 2020 01:47:13 -0600</td>\r\n          </tr>\r\n          <tr>\r\n            <th valign=\"BASELINE\" nowrap=\"nowrap\" align=\"RIGHT\">De: </th>\r\n            <td>Decathlon <a class=\"moz-txt-link-rfc2396E\" href=\"mailto:noreply@email.decathlon.es\">&lt;noreply@email.decathlon.es&gt;</a></td>\r\n          </tr>\r\n          <tr>\r\n            <th valign=\"BASELINE\" nowrap=\"nowrap\" align=\"RIGHT\">Responder\r\n              a: </th>\r\n            <td>Decathlon <a class=\"moz-txt-link-rfc2396E\" href=\"mailto:noreply@email.decathlon.com\">&lt;noreply@email.decathlon.com&gt;</a></td>\r\n          </tr>\r\n          <tr>\r\n            <th valign=\"BASELINE\" nowrap=\"nowrap\" align=\"RIGHT\">Para: </th>\r\n            <td><a class=\"moz-txt-link-abbreviated\" href=\"mailto:fernandohumanes@gmail.com\">fernandohumanes@gmail.com</a></td>\r\n          </tr>\r\n        </tbody>\r\n      </table>\r\n      <br>\r\n      <br>\r\n      <!-- Begin Email attributes -->\r\n      <!-- End email attributes-->\r\n      <!-- End Return Path tag-->\r\n      <!-- Track openers-->\r\n      <img\r\nsrc=\"http://click.email.decathlon.es/open.aspx?ffcb10-fe9115737c6d067d73-fe511275716c027a7112-fe8913727c6d067574-ff961075-fe5a117175610c78711d-ff2d17747d67&amp;d=70145\"\r\n        moz-do-not-send=\"true\" width=\"1\" height=\"1\">\r\n      <!-- end track openers->  <!-- Begin Return Path tag-->\r\n      <img\r\nsrc=\"http://pixel.app.returnpath.net/pixel.gif?r=db6bac137806ea3ce8525fe1f6e87b18a46e792a\"\r\n        moz-do-not-send=\"true\" width=\"1\" height=\"1\">\r\n      <img\r\nsrc=\"http://pixel.inbox.exacttarget.com/pixel.gif?r=db6bac137806ea3ce8525fe1f6e87b18a46e792a\"\r\n        moz-do-not-send=\"true\" width=\"1\" height=\"1\">\r\n      <!-- ===============================-->\r\n      <!--END Pixel image Return Path-->\r\n      <!-- ===============================-->\r\n      <!-- If you delete this tag, the sky will fall on your head -->\r\n      <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\r\n      <meta name=\"viewport\" content=\"width=device-width,\r\n        initial-scale=1.0\">\r\n      <title>DECATHLON</title>\r\n      <style type=\"text/css\">\r\n    @media screen {\r\n      @font-face {\r\n        font-family: \'Roboto Condensed\';\r\n        font-style: italic;\r\n        font-weight: 700;\r\n        src: local(\'Roboto Condensed Bold Italic\'), local(\'RobotoCondensed-BoldItalic\'), url(https://fonts.gstatic.com/s/robotocondensed/v16/ieVg2ZhZI2eCN5jzbjEETS9weq8-19eDtCYoY9NZQyQ.woff2) format(\'woff2\');\r\n        unicode-range: U+0100-024F, U+0259, U+1E00-1EFF, U+2020, U+20A0-20AB, U+20AD-20CF, U+2113, U+2C60-2C7F, U+A720-A7FF;\r\n      }\r\n\r\n      /* latin */\r\n      @font-face {\r\n        font-family: \'Roboto Condensed\';\r\n        font-style: italic;\r\n        font-weight: 700;\r\n        src: local(\'Roboto Condensed Bold Italic\'), local(\'RobotoCondensed-BoldItalic\'), url(https://fonts.gstatic.com/s/robotocondensed/v16/ieVg2ZhZI2eCN5jzbjEETS9weq8-19eDtCYobdNZ.woff2) format(\'woff2\');\r\n        unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+2000-206F, U+2074, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD;\r\n      }\r\n\r\n      /* latin-ext */\r\n      @font-face {\r\n        font-family: \'Roboto Condensed\';\r\n        font-style: normal;\r\n        font-weight: 300;\r\n        src: local(\'Roboto Condensed Light\'), local(\'RobotoCondensed-Light\'), url(https://fonts.gstatic.com/s/robotocondensed/v16/ieVi2ZhZI2eCN5jzbjEETS9weq8-33mZGCoYb8td.woff2) format(\'woff2\');\r\n        unicode-range: U+0100-024F, U+0259, U+1E00-1EFF, U+2020, U+20A0-20AB, U+20AD-20CF, U+2113, U+2C60-2C7F, U+A720-A7FF;\r\n      }\r\n\r\n      /* latin */\r\n      @font-face {\r\n        font-family: \'Roboto Condensed\';\r\n        font-style: normal;\r\n        font-weight: 300;\r\n        src: local(\'Roboto Condensed Light\'), local(\'RobotoCondensed-Light\'), url(https://fonts.gstatic.com/s/robotocondensed/v16/ieVi2ZhZI2eCN5jzbjEETS9weq8-33mZGCQYbw.woff2) format(\'woff2\');\r\n        unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+2000-206F, U+2074, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD;\r\n      }\r\n\r\n      /* latin-ext */\r\n      @font-face {\r\n        font-family: \'Roboto Condensed\';\r\n        font-style: normal;\r\n        font-weight: 700;\r\n        src: local(\'Roboto Condensed Bold\'), local(\'RobotoCondensed-Bold\'), url(https://fonts.gstatic.com/s/robotocondensed/v16/ieVi2ZhZI2eCN5jzbjEETS9weq8-32meGCoYb8td.woff2) format(\'woff2\');\r\n        unicode-range: U+0100-024F, U+0259, U+1E00-1EFF, U+2020, U+20A0-20AB, U+20AD-20CF, U+2113, U+2C60-2C7F, U+A720-A7FF;\r\n      }\r\n\r\n      /* latin */\r\n      @font-face {\r\n        font-family: \'Roboto Condensed\';\r\n        font-style: normal;\r\n        font-weight: 700;\r\n        src: local(\'Roboto Condensed Bold\'), local(\'RobotoCondensed-Bold\'), url(https://fonts.gstatic.com/s/robotocondensed/v16/ieVi2ZhZI2eCN5jzbjEETS9weq8-32meGCQYbw.woff2) format(\'woff2\');\r\n        unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+2000-206F, U+2074, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD;\r\n      }\r\n    }\r\n  </style>\r\n      <style type=\"text/css\">\r\n    #outlook a {\r\n      padding: 0;\r\n    }\r\n\r\n    body {\r\n      width: 100% !important;\r\n      -webkit-text-size-adjust: 100%;\r\n      -ms-text-size-adjust: 100%;\r\n      margin: 0;\r\n      padding: 0;\r\n    }\r\n\r\n    .ExternalClass {\r\n      width: 100%;\r\n    }\r\n\r\n    .ExternalClass,\r\n    .ExternalClass p,\r\n    .ExternalClass span,\r\n    .ExternalClass font,\r\n    .ExternalClass td,\r\n    .ExternalClass div {\r\n      line-height: 100%;\r\n    }\r\n\r\n    #backgroundTable {\r\n      margin: 0;\r\n      padding: 0;\r\n      width: 100% !important;\r\n      line-height: 100% !important;\r\n    }\r\n\r\n    img {\r\n      outline: none;\r\n      text-decoration: none;\r\n      -ms-interpolation-mode: bicubic;\r\n    }\r\n\r\n    a img {\r\n      border: none;\r\n    }\r\n\r\n    .image_fix {\r\n      display: block;\r\n    }\r\n\r\n    table td {\r\n      border-collapse: collapse;\r\n    }\r\n\r\n    table {\r\n      border-collapse: collapse;\r\n      mso-table-lspace: 0pt;\r\n      mso-table-rspace: 0pt;\r\n    }\r\n\r\n    /* ------------------------------------- \r\n    GLOBAL \r\n------------------------------------- */\r\n\r\n    * {\r\n      margin: 0;\r\n      padding: 0;\r\n    }\r\n\r\n    img {\r\n      max-width: 100%;\r\n    }\r\n\r\n    .collapse {\r\n      margin: 0;\r\n      padding: 0;\r\n    }\r\n\r\n    body {\r\n      -webkit-font-smoothing: antialiased;\r\n      -webkit-text-size-adjust: none;\r\n      width: 100% !important;\r\n      height: 100%;\r\n      font-family: \"Roboto Condensed\", \"Arial Condensed\", \"Helvetica Condensed\", Helvetica, Arial, sans-serif !important;\r\n      color: #706f6f;\r\n    }\r\n\r\n    /* ------------------------------------- \r\n    ELEMENTS \r\n------------------------------------- */\r\n\r\n    a {\r\n      text-decoration: none;\r\n    }\r\n\r\n    /* ------------------------------------- \r\n    HEADER \r\n------------------------------------- */\r\n\r\n    table.other-devices,\r\n    table.footer-wrap {\r\n      width: 100%;\r\n    }\r\n\r\n    /* ------------------------------------- \r\n    BODY \r\n------------------------------------- */\r\n\r\n    table.body-wrap {\r\n      width: 100%;\r\n    }\r\n\r\n    /* ------------------------------------- \r\n    FOOTER \r\n------------------------------------- */\r\n\r\n    table.footer-wrap {\r\n      width: 100%;\r\n      clear: both !important;\r\n    }\r\n\r\n    .footer-wrap a {\r\n      color: #706f6f;\r\n      font-size: 11px;\r\n    }\r\n\r\n    /* --------------------------------------------------- \r\n    RESPONSIVENESS\r\n    Nuke it from orbit. It\'s the only way to be sure. \r\n------------------------------------------------------ */\r\n    /* Set a max-width, and make it display as block so it will automatically stretch to that width, but will also shrink down on a phone or something */\r\n\r\n    .container {\r\n      display: block !important;\r\n      width: 650px !important;\r\n      margin: 0 auto !important;\r\n      clear: both !important;\r\n    }\r\n\r\n    /* This should also be a block element, so that it will fill 100% of the .container */\r\n\r\n    .content {\r\n      width: 650px;\r\n      margin: 0 auto;\r\n      display: block;\r\n    }\r\n\r\n    .footer-wrap .content-header {\r\n      max-width: 350px !important;\r\n      margin: 0 auto;\r\n      display: block;\r\n    }\r\n\r\n    /* Let\'s make sure tables in the content area are 100% wide */\r\n\r\n    .content table {\r\n      width: 100%;\r\n    }\r\n\r\n    #header-decathlon {\r\n      padding: 15px;\r\n    }\r\n\r\n    #decathlon-menu td a {\r\n      display: block;\r\n      text-decoration: none;\r\n      text-transform: uppercase;\r\n      color: #706f6f;\r\n    }\r\n\r\n    #decathlon-services td a {\r\n      text-decoration: none;\r\n      color: #000001;\r\n    }\r\n\r\n    .product .image,\r\n    .product .copy {\r\n      display: block;\r\n    }\r\n\r\n    .inside {\r\n      padding: 0 10%;\r\n    }\r\n\r\n    .descuentos_3_columnas .imagen {\r\n      padding: 30px 15px;\r\n    }\r\n\r\n    .just_mobile {\r\n      width: 0 !important;\r\n      max-height: 0 !important;\r\n      overflow: hidden !important;\r\n      float: left !important;\r\n      display: none !important;\r\n    }\r\n\r\n    @media screen and (max-width: 650px),\r\n    screen and (max-device-width: 650px) {\r\n      .container {\r\n        width: 100% !important;\r\n        max-width: 650px !important;\r\n      }\r\n\r\n      .content {\r\n        max-width: 650px !important;\r\n        width: 100% !important;\r\n      }\r\n\r\n      .no_mobile {\r\n        display: none !important;\r\n      }\r\n\r\n      .just_mobile {\r\n        width: 100% !important;\r\n        display: table !important;\r\n        height: auto !important;\r\n        max-height: none !important;\r\n        float: none !important;\r\n      }\r\n\r\n      #header-decathlon {\r\n        padding: 15px !important;\r\n      }\r\n\r\n      #header-decathlon td.logo {\r\n        display: block !important;\r\n        text-align: center !important;\r\n      }\r\n\r\n      #header-decathlon img {\r\n        display: block !important;\r\n        margin: 0 auto !important;\r\n      }\r\n\r\n      #decathlon-menu {\r\n        border-top: 1px solid #e8e8e8;\r\n      }\r\n\r\n      #decathlon-menu tr {\r\n        display: table !important;\r\n        width: 100% !important;\r\n      }\r\n\r\n      #decathlon-menu td {\r\n        width: 100% !important;\r\n        display: table-row !important;\r\n        max-width: none !important;\r\n      }\r\n\r\n      #decathlon-menu td {\r\n        border-bottom: 1px solid #e8e8e8;\r\n        padding: 0 !important;\r\n      }\r\n\r\n      #decathlon-menu td a {\r\n        padding: 15px 5px;\r\n        font-size: 14px !important;\r\n      }\r\n\r\n      .columnas {\r\n        display: table !important;\r\n        width: 100% !important;\r\n      }\r\n\r\n      .columnas .imagen {\r\n        width: 100% !important;\r\n        display: table-row !important;\r\n        max-width: none !important;\r\n      }\r\n\r\n      .columnas .imagen .txt img {\r\n        width: auto !important;\r\n      }\r\n\r\n      .columnas .space {\r\n        width: 0 !important;\r\n        display: table-row !important;\r\n        height: 0 !important\r\n      }\r\n\r\n      .columnas .space_vertical {\r\n        width: 100% !important;\r\n        height: 5px !important;\r\n      }\r\n\r\n      .columnas .copy {\r\n        width: 100% !important;\r\n        display: table-row !important;\r\n        margin-left: 2.5% !important;\r\n      }\r\n\r\n      .columnas .copy .receipt-info {\r\n        width: 95% !important;\r\n        margin-left: 2.5% !important;\r\n        margin-right: 2.5% !important;\r\n      }\r\n\r\n      .deca_dos_columnas.image {\r\n        width: 40% !important;\r\n      }\r\n\r\n      .deca_dos_columnas.copy {\r\n        width: 60% !important;\r\n      }\r\n\r\n      .product {\r\n        width: 100% !important;\r\n      }\r\n\r\n      .product .image,\r\n      .product .copy {\r\n        display: table-cell;\r\n      }\r\n\r\n      .product .image {\r\n        width: 40% !important;\r\n      }\r\n\r\n      .product .copy {\r\n        width: 60% !important;\r\n      }\r\n\r\n      .product .copy>table {\r\n        width: auto !important;\r\n      }\r\n\r\n      .info_product h2, .category_product h2 {\r\n        margin-bottom: 0 !important;\r\n      }\r\n\r\n      .product.product_inside .image,\r\n      .product.product_inside .copy {\r\n        display: table-cell !important;\r\n      }\r\n\r\n      .inside {\r\n        padding: 0 !important;\r\n      }\r\n\r\n      .mobile-transparent {\r\n        background-color: transparent !important;\r\n      }\r\n\r\n      .deca_dos_columnas_space {\r\n        display: none !important;\r\n        width: 0 !important;\r\n      }\r\n\r\n      .columnas.descuentos_3_columnas {\r\n        display: block !important;\r\n      }\r\n\r\n      .columnas.descuentos_3_columnas .imagen {\r\n        display: block !important;\r\n      }\r\n\r\n      .descuentos_3_columnas .imagen {\r\n        padding: 15px 0;\r\n      }\r\n\r\n      .descuentos_3_columnas .imagen .arrow_image {\r\n        display: none !important;\r\n        width: 0 !important;\r\n      }\r\n\r\n      .descuentos_3_columnas .imagen .arrow {\r\n        margin-left: 5px;\r\n        margin-top: 0 !important;\r\n        font-size: 18px !important;\r\n        display: inline !important;\r\n        width: auto !important;\r\n      }\r\n\r\n      .info_product .button {\r\n        line-height: 14px !important;\r\n        font-size: 14px !important;\r\n        padding: 8px 10px !important;\r\n      }\r\n\r\n      .height-0-mobile {\r\n        width: 100% !important;\r\n        display: table !important;\r\n        height: auto !important;\r\n        max-height: none !important;\r\n        float: none !important;\r\n      }\r\n\r\n    }\r\n\r\n    /* -------------------------------------------\r\n    PHONE\r\n    For clients that support media queries.\r\n    Nothing fancy.\r\n-------------------------------------------- */\r\n\r\n    @media screen and (max-width: 480px),\r\n    screen and (max-device-width: 480px) {\r\n\r\n      /* pantalla hace 650  */\r\n      table[class=\"mail-correct\"] {\r\n        display: none;\r\n      }\r\n\r\n      .footer-wrap .content-header,\r\n      .footer-wrap .content-header table {\r\n        max-width: 270px !important;\r\n      }\r\n\r\n      .footer-wrap .content-header .space {\r\n        width: 15px !important;\r\n      }\r\n\r\n      .info_product h1,\r\n      .info_product h1 a {\r\n        line-height: 16px !important;\r\n        font-size: 16px !important;\r\n      }\r\n\r\n      .info_product h2,\r\n      .info_product h2 a,\r\n      .info_product h3,\r\n      .info_product h3 a {\r\n        line-height: 14px !important;\r\n        font-size: 14px !important;\r\n      }\r\n\r\n      .info_product .price_before {\r\n        font-size: 14px !important;\r\n      }\r\n\r\n      .info_product .price {\r\n        font-size: 30px !important;\r\n        line-height: 30px !important;\r\n      }\r\n\r\n      .info_product .button {\r\n        line-height: 12px !important;\r\n        font-size: 12px !important;\r\n        padding: 8px 10px !important;\r\n      }\r\n    }\r\n\r\n    @media screen and (max-width: 320px),\r\n    screen and (max-device-width: 320px) {\r\n\r\n      .info_product .button {\r\n        line-height: 10px !important;\r\n        font-size: 10px !important;\r\n        padding: 5px 8px !important;\r\n      }\r\n    }\r\n  </style>\r\n      <style type=\"text/css\">\r\ndiv.preheader \r\n{ display: none !important; } \r\n</style>\r\n      <div class=\"preheader\" style=\"font-size: 1px; display: none\r\n        !important;\">?Envío y Devoluciones GRATIS a Tienda*</div>\r\n      <!--  PREHEADER  -->\r\n      <table class=\"mail-correct\" width=\"100%\" cellspacing=\"0\"\r\n        cellpadding=\"0\" border=\"0\">\r\n        <tbody>\r\n          <tr>\r\n            <td height=\"20\"><br>\r\n            </td>\r\n          </tr>\r\n          <tr>\r\n            <td style=\"color:#89878C; font-family:Arial, Helvetica,\r\n              sans-serif; font-size:11px; text-align:center;\"\r\n              valign=\"top\"> Si no visualizas bien este email pincha <a\r\nhref=\"http://view.email.decathlon.es/?qs=030295d61af7b0e5aa9a290615316fc455f186f0fcd0e0a994f33d35b22df2d658f7e05249d4cec38aaa5db6ac6cfe8d1eb65dc301335d3f6fb697961240b511287b29869b027f0476c9e5c5e85b0522\"\r\n                target=\"_blank\" style=\"color:#706f6f;\"\r\n                moz-do-not-send=\"true\">aquí</a></td>\r\n          </tr>\r\n        </tbody>\r\n      </table>\r\n      <!--  FIN PREHEADER  --><!--  HEADER  -->\r\n      <!--[if (gte mso 9)|(IE)]> <table align=\"center\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"650\"> <tr>   <td align=\"center\" valign=\"top\" width=\"650\">     <![endif]-->\r\n      <div class=\"content\" style=\"max-width:650px; margin: 0 auto\">\r\n        <table style=\"border-collapse: collapse; width: 100%;\"\r\n          cellspacing=\"0\" cellpadding=\"0\" border=\"0\" align=\"center\">\r\n          <tbody>\r\n            <tr>\r\n              <td id=\"header-decathlon\" style=\"padding:15px;\r\n                border-collapse: collapse;\">\r\n                <table width=\"100%\" cellspacing=\"0\" cellpadding=\"0\"\r\n                  border=\"0\">\r\n                  <tbody>\r\n                    <tr>\r\n                      <td style=\"border-collapse: collapse;width: 100%;\"\r\n                        valign=\"middle\">\r\n                        <table style=\"border-collapse: collapse; width:\r\n                          100%;\" width=\"100%\" cellspacing=\"0\"\r\n                          cellpadding=\"0\" border=\"0\" align=\"left\">\r\n                          <tbody>\r\n                            <tr>\r\n                              <td class=\"logo\" style=\"border-collapse:\r\n                                collapse;\" valign=\"middle\" align=\"left\"><a\r\nhref=\"http://click.email.decathlon.es/?qs=509a9c8079e838f07648139b524c5009df37ea827e4f5bf7c36b409032a24a891a01e7ec76bbe5bae77e87e0307e767fc3da82af84a00d2a2eff3242584bd8e7\"\r\n                                  target=\"_blank\" moz-do-not-send=\"true\"><img\r\nsrc=\"http://pictures.decathlon.spain.s3.amazonaws.com/opco_vad_cast_02102020/logo.gif\"\r\n                                    alt=\"Decathlon\"\r\n                                    style=\"display:block;\"\r\n                                    moz-do-not-send=\"true\"></a></td>\r\n                              <td class=\"no_mobile\"\r\n                                style=\"border-collapse: collapse;\"\r\n                                width=\"150\" valign=\"middle\"\r\n                                align=\"right\"> <a\r\nhref=\"http://click.email.decathlon.es/?qs=509a9c8079e838f022677aa2df2ff040fcaf1e79fbc7c5c1b081d5368defade7b69edcfa1677b04bd3e4d7725c81290f1d4224130298f86c697fd9683f1cb299\"\r\n                                  target=\"_blank\" style=\"color:#706f6f;\r\n                                  text-decoration: none;\"\r\n                                  moz-do-not-send=\"true\">Accede a tu<br>\r\n                                  <span style=\"color:#165eb9;\"> espacio\r\n                                    personal</span></a> </td>\r\n                              <td class=\"no_mobile\"\r\n                                style=\"border-collapse: collapse;\"\r\n                                width=\"45\" valign=\"middle\" align=\"right\">\r\n                                <a\r\nhref=\"http://click.email.decathlon.es/?qs=509a9c8079e838f022677aa2df2ff040fcaf1e79fbc7c5c1b081d5368defade7b69edcfa1677b04bd3e4d7725c81290f1d4224130298f86c697fd9683f1cb299\"\r\n                                  target=\"_blank\" moz-do-not-send=\"true\"><img\r\nsrc=\"http://pictures.decathlon.spain.s3.amazonaws.com/opco_vad_cast_02102020/usuario.gif\"\r\n                                    alt=\"Accede a tu espacio personal\"\r\n                                    style=\"display:block;\r\n                                    text-decoration: none;\"\r\n                                    moz-do-not-send=\"true\"></a> </td>\r\n                            </tr>\r\n                          </tbody>\r\n                        </table>\r\n                      </td>\r\n                    </tr>\r\n                  </tbody>\r\n                </table>\r\n              </td>\r\n            </tr>\r\n          </tbody>\r\n        </table>\r\n      </div>\r\n      <!--[if (gte mso 9)|(IE)]>     </td>   </tr> </table> <![endif]-->\r\n      <table class=\"no_mobile\" width=\"100%\" cellspacing=\"0\"\r\n        cellpadding=\"0\" border=\"0\">\r\n        <tbody>\r\n          <tr>\r\n            <td height=\"10\"><br>\r\n            </td>\r\n          </tr>\r\n        </tbody>\r\n      </table>\r\n      <!--[if (gte mso 9)|(IE)]> <table align=\"center\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"650\">   <tr>     <td align=\"center\" valign=\"top\" width=\"650\">       <![endif]-->\r\n      <div class=\"content\" style=\"max-width:650px; margin: 0 auto\">\r\n        <table class=\"no_mobile\" style=\"width: 100%; border-collapse:\r\n          collapse;\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\"\r\n          align=\"center\">\r\n          <style type=\"text/css\">\r\n#decathlon-menu a { font-size: 18px; }\r\n#decathlon-menu td { padding-left: 15px; }\r\n#decathlon-menu td.no-padding { padding-left: 0; }\r\n</style><tbody>\r\n            <tr>\r\n              <td>\r\n                <table id=\"decathlon-menu\" width=\"100%\" cellspacing=\"0\"\r\n                  cellpadding=\"0\" border=\"0\">\r\n                  <tbody>\r\n                    <tr>\r\n                      <td class=\"no-padding\" style=\"padding-left: 0;\"\r\n                        align=\"center\"><a\r\nhref=\"http://click.email.decathlon.es/?qs=509a9c8079e838f07648139b524c5009df37ea827e4f5bf7c36b409032a24a891a01e7ec76bbe5bae77e87e0307e767fc3da82af84a00d2a2eff3242584bd8e7\"\r\n                          style=\"display: block;text-decoration:\r\n                          none;text-transform: uppercase;color:\r\n                          #706f6f;font-size: 18px;\"\r\n                          moz-do-not-send=\"true\">Deportes</a></td>\r\n                      <td style=\"padding-left: 15px;\" align=\"center\"><a\r\nhref=\"http://click.email.decathlon.es/?qs=509a9c8079e838f06a9e2703fac9c435da33eb1154802430445f4c17d4b720347f495a3d63e9f838dc3f5492f4d3f1c0e2939b6383c71aac55726cde557577c7\"\r\n                          style=\"display: block;text-decoration:\r\n                          none;text-transform: uppercase;color:\r\n                          #706f6f;font-size: 18px;\"\r\n                          moz-do-not-send=\"true\">Mujer</a></td>\r\n                      <td style=\"padding-left: 15px;\" align=\"center\"><a\r\nhref=\"http://click.email.decathlon.es/?qs=509a9c8079e838f0b82519693706f5c25858d6be1d9ad55a50a4a6b204efc2efc8c41af575f0fdc2316ad414ab2b5bca445444fa6bf469e7155c75e89d7433ab\"\r\n                          style=\"display: block;text-decoration:\r\n                          none;text-transform: uppercase;color:\r\n                          #706f6f;font-size: 18px;\"\r\n                          moz-do-not-send=\"true\">Niños</a></td>\r\n                      <td style=\"padding-left: 15px;\" align=\"center\"><a\r\nhref=\"http://click.email.decathlon.es/?qs=509a9c8079e838f0536c88a577aee1c38275102f8ad0faec0cfd31c8b56e273dd67f16cfa6ac2671dce4094a56e120dbccd80d0b792f0e8e98a814abca3d5979\"\r\n                          style=\"display: block;text-decoration:\r\n                          none;text-transform: uppercase;color:\r\n                          #706f6f;font-size: 18px;\"\r\n                          moz-do-not-send=\"true\">Hombre</a></td>\r\n                      <td style=\"padding-left: 15px;\" align=\"center\"><a\r\nhref=\"http://click.email.decathlon.es/?qs=509a9c8079e838f0d20bb9cd492759ee7b0abb6830f588615c7b01dee9bfa9318870b364dd5400a7afb1563d65e39d8b9ca8ebe5384c6ca59631439c333a7057\"\r\n                          style=\"display: block;text-decoration:\r\n                          none;text-transform: uppercase;color:\r\n                          #706f6f;font-size: 18px;\"\r\n                          moz-do-not-send=\"true\">Accesorios</a></td>\r\n                      <td style=\"padding-left: 15px;\" align=\"center\"><a\r\nhref=\"http://click.email.decathlon.es/?qs=509a9c8079e838f067a43630bf6c320d46ff3d4256a5fb337c399cd0b5522bd445ca7f9e4ebe85836998813eb6f1d8275d0bde3dd26ac60cf7c96ed980265165\"\r\n                          style=\"display: block;text-decoration:\r\n                          none;text-transform: uppercase;color:\r\n                          #E20C18;font-size: 18px;\"\r\n                          moz-do-not-send=\"true\">Últimas unidades</a></td>\r\n                    </tr>\r\n                  </tbody>\r\n                </table>\r\n              </td>\r\n            </tr>\r\n          </tbody>\r\n        </table>\r\n      </div>\r\n      <!--[if (gte mso 9)|(IE)]>     </td>   </tr> </table> <![endif]-->\r\n      <table width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\">\r\n        <tbody>\r\n          <tr>\r\n            <td height=\"20\"><br>\r\n            </td>\r\n          </tr>\r\n        </tbody>\r\n      </table>\r\n      <!--[if (gte mso 9)|(IE)]> <table align=\"center\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"650\">   <tr>     <td align=\"center\" valign=\"top\" width=\"650\">     <![endif]-->\r\n      <div class=\"content\" style=\"max-width:650px; margin: 0 auto\">\r\n        <table cellspacing=\"0\" cellpadding=\"0\" border=\"0\">\r\n          <tbody>\r\n            <tr>\r\n              <td align=\"center\">\r\n                <!--[if !mso]><!--> <a\r\nhref=\"http://click.email.decathlon.es/?qs=509a9c8079e838f0d21074d9f0c864d4c5a6a73a64d288605216d259e096a07230eb6f49a6f0b65bc4e956a4fc3794fd80e97a616c5592a39512e9e1159bbe41\"\r\n                  target=\"_blank\" title=\"¡VUELTA AL DEPORTE!\"\r\n                  moz-do-not-send=\"true\"> <img class=\"just_mobile\"\r\nsrc=\"http://pictures.decathlon.spain.s3.amazonaws.com/opco_vad_cast_02102020/img_01.jpg\"\r\n                    alt=\"¡VUELTA AL DEPORTE!\" style=\"width: 0;\r\n                    max-height: 0; overflow: hidden; float:left\"\r\n                    moz-do-not-send=\"true\" border=\"0\"> </a>\r\n                <!--<![endif]--> <a\r\nhref=\"http://click.email.decathlon.es/?qs=509a9c8079e838f0d21074d9f0c864d4c5a6a73a64d288605216d259e096a07230eb6f49a6f0b65bc4e956a4fc3794fd80e97a616c5592a39512e9e1159bbe41\"\r\n                  target=\"_blank\" title=\"¡VUELTA AL DEPORTE!\"\r\n                  moz-do-not-send=\"true\"> <img class=\"no_mobile\"\r\nsrc=\"http://pictures.decathlon.spain.s3.amazonaws.com/opco_vad_cast_02102020/img_01.jpg\"\r\n                    alt=\"¡VUELTA AL DEPORTE!\"\r\n                    style=\"display:block;width:100%; height:auto;\"\r\n                    moz-do-not-send=\"true\" border=\"0\"> </a> </td>\r\n            </tr>\r\n          </tbody>\r\n        </table>\r\n      </div>\r\n      <!--[if (gte mso 9)|(IE)]>     </td>   </tr> </table> <![endif]-->\r\n      <!--[if (gte mso 9)|(IE)]> <table align=\"center\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"650\">  <tr>    <td align=\"center\" valign=\"top\" width=\"650\">      <![endif]-->\r\n      <div class=\"content\" style=\"max-width:650px; margin: 0 auto\">\r\n        <table width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\"\r\n          bgcolor=\"#ffffff\">\r\n          <tbody>\r\n            <tr>\r\n              <td height=\"20\"><br>\r\n              </td>\r\n            </tr>\r\n          </tbody>\r\n        </table>\r\n      </div>\r\n      <!--[if (gte mso 9)|(IE)]>     </td>   </tr> </table> <![endif]--><!--[if (gte mso 9)|(IE)]> <table align=\"center\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"650\">   <tr>     <td align=\"center\" valign=\"top\" width=\"650\">     <![endif]-->\r\n      <div class=\"content\" style=\"width:100%;max-width:650px;margin: 0\r\n        auto;background-color:#ffffff;\">\r\n        <table cellspacing=\"0\" cellpadding=\"0\" border=\"0\"\r\n          bgcolor=\"#ffffff\" align=\"center\">\r\n          <tbody>\r\n            <tr>\r\n              <td height=\"10\"><br>\r\n              </td>\r\n            </tr>\r\n            <tr>\r\n              <td style=\"padding: 0 15px;\" align=\"center\">\r\n                <h1 style=\"margin:0; color:#4d4d4d;line-height:34px;\r\n                  font-size:28px; text-transform:uppercase;\"> <a\r\nhref=\"http://click.email.decathlon.es/?qs=509a9c8079e838f0b88159dea2a190980d04d08a02e5360c0b002c59a02ab0ef6b60f5174e8c91c4ca0e976014576b49ba5b082d78e5d84983cb3189f29bdeb9\"\r\n                    title=\"¡VUELTA AL DEPORTE!\"\r\n                    style=\"text-decoration:none;\r\n                    color:#4d4d4d;line-height:34px; font-size:28px;\r\n                    text-transform:uppercase;\" moz-do-not-send=\"true\">\r\n                    <div> </div>\r\n                    <span style=\"display: block; margin-top: -30px;\">¡VUELTA\r\n                      AL DEPORTE!</span> </a> </h1>\r\n              </td>\r\n            </tr>\r\n            <tr>\r\n              <td height=\"10\"><br>\r\n              </td>\r\n            </tr>\r\n          </tbody>\r\n        </table>\r\n      </div>\r\n      <!--[if (gte mso 9)|(IE)]>     </td>   </tr> </table> <![endif]--><!--[if (gte mso 9)|(IE)]> <table align=\"center\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"650\">   <tr>     <td align=\"center\" valign=\"top\" width=\"650\">     <![endif]-->\r\n      <div class=\"content\" style=\"width:100%;max-width:650px; margin: 0\r\n        auto;background-color:#ffffff;\">\r\n        <table cellspacing=\"0\" cellpadding=\"0\" border=\"0\"\r\n          bgcolor=\"#ffffff\" align=\"center\">\r\n          <tbody>\r\n            <tr>\r\n              <td height=\"25\"><br>\r\n              </td>\r\n            </tr>\r\n            <tr>\r\n              <td align=\"center\"> <a\r\nhref=\"http://click.email.decathlon.es/?qs=509a9c8079e838f0b88159dea2a190980d04d08a02e5360c0b002c59a02ab0ef6b60f5174e8c91c4ca0e976014576b49ba5b082d78e5d84983cb3189f29bdeb9\"\r\n                  class=\"button\" title=\"DESCUBRE LA COLECCIÓN\"\r\n                  style=\"text-decoration:none; color:#000;\r\n                  font-weight:700; text-transform:uppercase;\r\n                  line-height:16px; font-size:16px;\r\n                  background-color:#ffea28; padding:12px 18px; \"\r\n                  moz-do-not-send=\"true\">DESCUBRE LA COLECCIÓN</a></td>\r\n            </tr>\r\n            <tr>\r\n              <td height=\"25\"><br>\r\n              </td>\r\n            </tr>\r\n          </tbody>\r\n        </table>\r\n      </div>\r\n      <!--[if (gte mso 9)|(IE)]>     </td>   </tr> </table> <![endif]-->\r\n      <!--[if (gte mso 9)|(IE)]> <table align=\"center\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"650\">  <tr>    <td align=\"center\" valign=\"top\" width=\"650\">      <![endif]-->\r\n      <div class=\"content\" style=\"max-width:650px; margin: 0 auto\">\r\n        <table width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\"\r\n          bgcolor=\"#ffffff\">\r\n          <tbody>\r\n            <tr>\r\n              <td height=\"20\"><br>\r\n              </td>\r\n            </tr>\r\n          </tbody>\r\n        </table>\r\n      </div>\r\n      <!--[if (gte mso 9)|(IE)]>     </td>   </tr> </table> <![endif]-->\r\n      <!--[if (gte mso 9)|(IE)]> <table align=\"center\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"650\">  <tr>    <td align=\"center\" valign=\"top\" width=\"650\">      <![endif]-->\r\n      <div class=\"content\" style=\"max-width:650px; margin: 0 auto\">\r\n        <table width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\"\r\n          bgcolor=\"#ffffff\">\r\n          <tbody>\r\n            <tr>\r\n              <td height=\"20\"><br>\r\n              </td>\r\n            </tr>\r\n          </tbody>\r\n        </table>\r\n      </div>\r\n      <!--[if (gte mso 9)|(IE)]>     </td>   </tr> </table> <![endif]--><!--[if (gte mso 9)|(IE)]> <table align=\"center\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"650\">  <tr>    <td align=\"center\" valign=\"top\" width=\"650\">      <![endif]-->\r\n      <div class=\"content\" style=\"max-width:650px; margin: 0 auto\">\r\n        <div>\r\n          <table cellspacing=\"0\" cellpadding=\"0\" border=\"0\"\r\n            bgcolor=\"#ffffff\" align=\"center\">\r\n            <tbody>\r\n              <tr>\r\n                <td style=\"max-width:295px; width:49.16666666666667%;\"\r\n                  valign=\"top\">\r\n                  <table class=\"product product_inside\" cellspacing=\"0\"\r\n                    cellpadding=\"0\" border=\"0\">\r\n                    <tbody>\r\n                      <tr>\r\n                        <td> <a style=\"display:block;\"\r\nhref=\"http://click.email.decathlon.es/?qs=509a9c8079e838f0a7da584ecd3f6005da28ac886d678ae24590aca7113a17dd81e7cea88a3ca2875fafcc114018ea01de913bf19b103cc64e92dcfc679908c5\"\r\n                            title=\"Decathlon\" moz-do-not-send=\"true\"> <img\r\nsrc=\"http://pictures.decathlon.spain.s3.amazonaws.com/opco_vad_cast_02102020/img_02.jpg\"\r\n                              alt=\"Decathlon\"\r\n                              style=\"display:block;width:100%;\r\n                              height:auto;\" moz-do-not-send=\"true\"\r\n                              border=\"0\"> </a> </td>\r\n                      </tr>\r\n                      <tr>\r\n                        <td>\r\n                          <table cellspacing=\"0\" cellpadding=\"0\"\r\n                            border=\"0\">\r\n                            <tbody>\r\n                              <tr>\r\n                                <td align=\"center\">\r\n                                  <table cellspacing=\"0\" cellpadding=\"0\"\r\n                                    border=\"0\">\r\n                                    <tbody>\r\n                                      <tr>\r\n                                        <td width=\"15\"> </td>\r\n                                        <td class=\"info_product\"\r\n                                          align=\"center\">\r\n                                          <h1\r\n                                            style=\"margin:0;line-height:30px;\r\n                                            font-size:25px;\r\n                                            text-transform:uppercase;font-weight:\r\n                                            300;\"><a\r\nhref=\"http://click.email.decathlon.es/?qs=509a9c8079e838f0a7da584ecd3f6005da28ac886d678ae24590aca7113a17dd81e7cea88a3ca2875fafcc114018ea01de913bf19b103cc64e92dcfc679908c5\"\r\n                                              title=\"Decathlon\"\r\n                                              style=\"text-decoration:none;\r\ncolor:#4d4d4d;line-height:30px; font-size:25px;\r\n                                              text-transform:uppercase;font-weight:\r\n                                              300;\"\r\n                                              moz-do-not-send=\"true\"><span\r\n                                                style=\"display: block;\r\n                                                margin-top: 15px;\">KALENJI</span></a></h1>\r\n                                          <h2\r\n                                            style=\"line-height:30px;font-size:25px;\r\n                                            text-transform:uppercase;\r\n                                            font-weight: 700; margin:\r\n                                            5px 0 0 0;\"><a\r\nhref=\"http://click.email.decathlon.es/?qs=509a9c8079e838f0a7da584ecd3f6005da28ac886d678ae24590aca7113a17dd81e7cea88a3ca2875fafcc114018ea01de913bf19b103cc64e92dcfc679908c5\"\r\n                                              title=\"Decathlon\"\r\n                                              style=\"text-decoration:none;\r\n                                              color:#4d4d4d;\r\n                                              line-height:30px;font-size:25px;\r\n                                              text-transform:uppercase;\r\n                                              font-weight: 700;\"\r\n                                              moz-do-not-send=\"true\">ZAPATILLAS<br>\r\n                                              <span style=\"font-weight:\r\n                                                300;\">RUN MUJER</span></a></h2>\r\n                                          <div style=\"margin-top:\r\n                                            10px;margin-bottom:\r\n                                            20px;text-align: center;\"> </div>\r\n                                          <a\r\nhref=\"http://click.email.decathlon.es/?qs=509a9c8079e838f0a7da584ecd3f6005da28ac886d678ae24590aca7113a17dd81e7cea88a3ca2875fafcc114018ea01de913bf19b103cc64e92dcfc679908c5\"\r\n                                            class=\"button\" title=\"VER\r\n                                            LOS PRODUCTOS\"\r\n                                            style=\"text-decoration:none;\r\n                                            color:#000; font-weight:700;\r\n                                            text-transform:uppercase;\r\n                                            line-height:16px;\r\n                                            font-size:16px;\r\n                                            background-color:#ffea28;\r\n                                            padding:12px 18px;\"\r\n                                            moz-do-not-send=\"true\">VER\r\n                                            LOS PRODUCTOS</a> </td>\r\n                                        <td width=\"15\"> </td>\r\n                                      </tr>\r\n                                    </tbody>\r\n                                  </table>\r\n                                </td>\r\n                              </tr>\r\n                              <tr>\r\n                                <td style=\"display:block;height:40px;\"\r\n                                  width=\"100%\" height=\"40\"> </td>\r\n                              </tr>\r\n                            </tbody>\r\n                          </table>\r\n                        </td>\r\n                      </tr>\r\n                    </tbody>\r\n                  </table>\r\n                </td>\r\n                <td class=\"space\" style=\"width:1.666666666666667%;\r\n                  min-width:10px;\"><br>\r\n                </td>\r\n                <td style=\"max-width:295px; width:49.16666666666667%;\"\r\n                  valign=\"top\">\r\n                  <table class=\"product product_inside\" cellspacing=\"0\"\r\n                    cellpadding=\"0\" border=\"0\">\r\n                    <tbody>\r\n                      <tr>\r\n                        <td> <a style=\"display:block;\"\r\nhref=\"http://click.email.decathlon.es/?qs=509a9c8079e838f00ebb2e7e044e1cb0d400726ee35b51e6d9bd8e19ce1ee5a468b3e67aee605ffad4867d4469d9785f022f499b3d37aa5da878870860f2c33d\"\r\n                            title=\"Decathlon\" moz-do-not-send=\"true\"> <img\r\nsrc=\"http://pictures.decathlon.spain.s3.amazonaws.com/opco_vad_cast_02102020/img_03.jpg\"\r\n                              alt=\"Decathlon\"\r\n                              style=\"display:block;width:100%;\r\n                              height:auto;\" moz-do-not-send=\"true\"\r\n                              border=\"0\"> </a> </td>\r\n                      </tr>\r\n                      <tr>\r\n                        <td>\r\n                          <table cellspacing=\"0\" cellpadding=\"0\"\r\n                            border=\"0\">\r\n                            <tbody>\r\n                              <tr>\r\n                                <td align=\"center\">\r\n                                  <table cellspacing=\"0\" cellpadding=\"0\"\r\n                                    border=\"0\">\r\n                                    <tbody>\r\n                                      <tr>\r\n                                        <td width=\"15\"> </td>\r\n                                        <td class=\"info_product\"\r\n                                          align=\"center\">\r\n                                          <h1\r\n                                            style=\"margin:0;line-height:30px;\r\n                                            font-size:25px;\r\n                                            text-transform:uppercase;font-weight:\r\n                                            300\"><a\r\nhref=\"http://click.email.decathlon.es/?qs=509a9c8079e838f00ebb2e7e044e1cb0d400726ee35b51e6d9bd8e19ce1ee5a468b3e67aee605ffad4867d4469d9785f022f499b3d37aa5da878870860f2c33d\"\r\n                                              title=\"Decathlon\"\r\n                                              style=\"text-decoration:none;\r\ncolor:#4d4d4d;line-height:30px; font-size:25px;\r\n                                              text-transform:uppercase;\r\n                                              font-weight: 300\"\r\n                                              moz-do-not-send=\"true\"><span\r\n                                                style=\"display: block;\r\n                                                margin-top: 15px;\">KALENJI</span></a></h1>\r\n                                          <h2\r\n                                            style=\"line-height:30px;font-size:25px;\r\n                                            text-transform:uppercase;\r\n                                            font-weight: 700; margin:\r\n                                            5px 0 0 0;\"><a\r\nhref=\"http://click.email.decathlon.es/?qs=509a9c8079e838f00ebb2e7e044e1cb0d400726ee35b51e6d9bd8e19ce1ee5a468b3e67aee605ffad4867d4469d9785f022f499b3d37aa5da878870860f2c33d\"\r\n                                              title=\"Decathlon\"\r\n                                              style=\"text-decoration:none;\r\n                                              color:#4d4d4d;\r\n                                              line-height:30px;font-size:25px;\r\n                                              text-transform:uppercase;\r\n                                              font-weight: 700;\"\r\n                                              moz-do-not-send=\"true\">ZAPATILLAS<br>\r\n                                              <span style=\"font-weight:\r\n                                                300;\">RUN HOMBRE</span></a></h2>\r\n                                          <div style=\"margin-top:\r\n                                            10px;margin-bottom:\r\n                                            20px;text-align: center;\"> </div>\r\n                                          <a\r\nhref=\"http://click.email.decathlon.es/?qs=509a9c8079e838f00ebb2e7e044e1cb0d400726ee35b51e6d9bd8e19ce1ee5a468b3e67aee605ffad4867d4469d9785f022f499b3d37aa5da878870860f2c33d\"\r\n                                            class=\"button\" title=\"VER\r\n                                            LOS PRODUCTOS\"\r\n                                            style=\"text-decoration:none;\r\n                                            color:#000; font-weight:700;\r\n                                            text-transform:uppercase;\r\n                                            line-height:16px;\r\n                                            font-size:16px;\r\n                                            background-color:#ffea28;\r\n                                            padding:12px 18px;\"\r\n                                            moz-do-not-send=\"true\">VER\r\n                                            LOS PRODUCTOS</a> </td>\r\n                                        <td width=\"15\"> </td>\r\n                                      </tr>\r\n                                    </tbody>\r\n                                  </table>\r\n                                </td>\r\n                              </tr>\r\n                              <tr>\r\n                                <td style=\"display:block;height:40px;\"\r\n                                  width=\"100%\" height=\"40\"> </td>\r\n                              </tr>\r\n                            </tbody>\r\n                          </table>\r\n                        </td>\r\n                      </tr>\r\n                    </tbody>\r\n                  </table>\r\n                </td>\r\n              </tr>\r\n            </tbody>\r\n          </table>\r\n        </div>\r\n      </div>\r\n      <!--[if (gte mso 9)|(IE)]>    </td>  </tr> </table> <![endif]-->\r\n      <!--[if (gte mso 9)|(IE)]> <table align=\"center\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"650\">  <tr>    <td align=\"center\" valign=\"top\" width=\"650\">      <![endif]-->\r\n      <div class=\"content\" style=\"max-width:650px; margin: 0 auto\">\r\n        <table width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\"\r\n          bgcolor=\"#ffffff\">\r\n          <tbody>\r\n            <tr>\r\n              <td height=\"20\"><br>\r\n              </td>\r\n            </tr>\r\n          </tbody>\r\n        </table>\r\n      </div>\r\n      <!--[if (gte mso 9)|(IE)]>     </td>   </tr> </table> <![endif]-->\r\n      <!--[if (gte mso 9)|(IE)]> <table align=\"center\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"650\">  <tr>    <td align=\"center\" valign=\"top\" width=\"650\">      <![endif]-->\r\n      <div class=\"content\" style=\"max-width:650px; margin: 0 auto\">\r\n        <table width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\"\r\n          bgcolor=\"#ffffff\">\r\n          <tbody>\r\n            <tr>\r\n              <td height=\"20\"><br>\r\n              </td>\r\n            </tr>\r\n          </tbody>\r\n        </table>\r\n      </div>\r\n      <!--[if (gte mso 9)|(IE)]>     </td>   </tr> </table> <![endif]--><!--[if (gte mso 9)|(IE)]> <table align=\"center\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"650\">  <tr>    <td align=\"center\" valign=\"top\" width=\"650\">      <![endif]-->\r\n      <div class=\"content\" style=\"max-width:650px; margin: 0 auto\">\r\n        <div>\r\n          <table cellspacing=\"0\" cellpadding=\"0\" border=\"0\"\r\n            bgcolor=\"#ffffff\" align=\"center\">\r\n            <tbody>\r\n              <tr>\r\n                <td style=\"max-width:295px; width:49.16666666666667%;\"\r\n                  valign=\"top\">\r\n                  <table class=\"product product_inside\" cellspacing=\"0\"\r\n                    cellpadding=\"0\" border=\"0\">\r\n                    <tbody>\r\n                      <tr>\r\n                        <td> <a style=\"display:block;\"\r\nhref=\"http://click.email.decathlon.es/?qs=509a9c8079e838f0f5851479ae762a6f9fd3b79c6d83ef366dd7377a91a87117294d8213bcb2de5b3f518d5a2307a42455ad263e2fc4d6ff05b668bfb039d65f\"\r\n                            title=\"Decathlon\" moz-do-not-send=\"true\"> <img\r\nsrc=\"http://pictures.decathlon.spain.s3.amazonaws.com/opco_vad_cast_02102020/img_04.jpg\"\r\n                              alt=\"Decathlon\"\r\n                              style=\"display:block;width:100%;\r\n                              height:auto;\" moz-do-not-send=\"true\"\r\n                              border=\"0\"> </a> </td>\r\n                      </tr>\r\n                      <tr>\r\n                        <td>\r\n                          <table cellspacing=\"0\" cellpadding=\"0\"\r\n                            border=\"0\">\r\n                            <tbody>\r\n                              <tr>\r\n                                <td align=\"center\">\r\n                                  <table cellspacing=\"0\" cellpadding=\"0\"\r\n                                    border=\"0\">\r\n                                    <tbody>\r\n                                      <tr>\r\n                                        <td width=\"15\"> </td>\r\n                                        <td class=\"info_product\"\r\n                                          align=\"center\">\r\n                                          <h1\r\n                                            style=\"margin:0;line-height:30px;\r\n                                            font-size:25px;\r\n                                            text-transform:uppercase;font-weight:\r\n                                            300;\"><a\r\nhref=\"http://click.email.decathlon.es/?qs=509a9c8079e838f0f5851479ae762a6f9fd3b79c6d83ef366dd7377a91a87117294d8213bcb2de5b3f518d5a2307a42455ad263e2fc4d6ff05b668bfb039d65f\"\r\n                                              title=\"Decathlon\"\r\n                                              style=\"text-decoration:none;\r\ncolor:#4d4d4d;line-height:30px; font-size:25px;\r\n                                              text-transform:uppercase;font-weight:\r\n                                              300;\"\r\n                                              moz-do-not-send=\"true\"><strong><span\r\n                                                  style=\"display: block;\r\n                                                  margin-top: 15px;\">ZAPATILLAS\r\n                                                  RUNNING</span></strong></a></h1>\r\n                                          <div style=\"margin-top:\r\n                                            10px;margin-bottom:\r\n                                            20px;text-align: center;\"> </div>\r\n                                          <a\r\nhref=\"http://click.email.decathlon.es/?qs=509a9c8079e838f0f5851479ae762a6f9fd3b79c6d83ef366dd7377a91a87117294d8213bcb2de5b3f518d5a2307a42455ad263e2fc4d6ff05b668bfb039d65f\"\r\n                                            class=\"button\" title=\"VER\r\n                                            LOS PRODUCTOS\"\r\n                                            style=\"text-decoration:none;\r\n                                            color:#000; font-weight:700;\r\n                                            text-transform:uppercase;\r\n                                            line-height:16px;\r\n                                            font-size:16px;\r\n                                            background-color:#ffea28;\r\n                                            padding:12px 18px;\"\r\n                                            moz-do-not-send=\"true\">VER\r\n                                            LOS PRODUCTOS</a> </td>\r\n                                        <td width=\"15\"> </td>\r\n                                      </tr>\r\n                                    </tbody>\r\n                                  </table>\r\n                                </td>\r\n                              </tr>\r\n                              <tr>\r\n                                <td style=\"display:block;height:40px;\"\r\n                                  width=\"100%\" height=\"40\"> </td>\r\n                              </tr>\r\n                            </tbody>\r\n                          </table>\r\n                        </td>\r\n                      </tr>\r\n                    </tbody>\r\n                  </table>\r\n                </td>\r\n                <td class=\"space\" style=\"width:1.666666666666667%;\r\n                  min-width:10px;\"><br>\r\n                </td>\r\n                <td style=\"max-width:295px; width:49.16666666666667%;\"\r\n                  valign=\"top\">\r\n                  <table class=\"product product_inside\" cellspacing=\"0\"\r\n                    cellpadding=\"0\" border=\"0\">\r\n                    <tbody>\r\n                      <tr>\r\n                        <td> <a style=\"display:block;\"\r\nhref=\"http://click.email.decathlon.es/?qs=509a9c8079e838f08fc868faf98e2dfa9bf73dd63f08c7f6e3743fe6b68ae5dacf4a9109709ffe6d82fe8ceba462a812d741ffa33a849a1c4f51f6667c40a28a\"\r\n                            title=\"Decathlon\" moz-do-not-send=\"true\"> <img\r\nsrc=\"http://pictures.decathlon.spain.s3.amazonaws.com/opco_vad_cast_02102020/img_05.jpg\"\r\n                              alt=\"Decathlon\"\r\n                              style=\"display:block;width:100%;\r\n                              height:auto;\" moz-do-not-send=\"true\"\r\n                              border=\"0\"> </a> </td>\r\n                      </tr>\r\n                      <tr>\r\n                        <td>\r\n                          <table cellspacing=\"0\" cellpadding=\"0\"\r\n                            border=\"0\">\r\n                            <tbody>\r\n                              <tr>\r\n                                <td align=\"center\">\r\n                                  <table cellspacing=\"0\" cellpadding=\"0\"\r\n                                    border=\"0\">\r\n                                    <tbody>\r\n                                      <tr>\r\n                                        <td width=\"15\"> </td>\r\n                                        <td class=\"info_product\"\r\n                                          align=\"center\">\r\n                                          <h1\r\n                                            style=\"margin:0;line-height:30px;\r\n                                            font-size:25px;\r\n                                            text-transform:uppercase;font-weight:\r\n                                            300\"><a\r\nhref=\"http://click.email.decathlon.es/?qs=509a9c8079e838f08fc868faf98e2dfa9bf73dd63f08c7f6e3743fe6b68ae5dacf4a9109709ffe6d82fe8ceba462a812d741ffa33a849a1c4f51f6667c40a28a\"\r\n                                              title=\"Decathlon\"\r\n                                              style=\"text-decoration:none;\r\ncolor:#4d4d4d;line-height:30px; font-size:25px;\r\n                                              text-transform:uppercase;\r\n                                              font-weight: 300\"\r\n                                              moz-do-not-send=\"true\"><strong><span\r\n                                                  style=\"display: block;\r\n                                                  margin-top: 15px;\">ZAPATILLAS\r\n                                                  TREKKING</span></strong></a></h1>\r\n                                          <div style=\"margin-top:\r\n                                            10px;margin-bottom:\r\n                                            20px;text-align: center;\"> </div>\r\n                                          <a\r\nhref=\"http://click.email.decathlon.es/?qs=509a9c8079e838f08fc868faf98e2dfa9bf73dd63f08c7f6e3743fe6b68ae5dacf4a9109709ffe6d82fe8ceba462a812d741ffa33a849a1c4f51f6667c40a28a\"\r\n                                            class=\"button\" title=\"VER\r\n                                            LOS PRODUCTOS\"\r\n                                            style=\"text-decoration:none;\r\n                                            color:#000; font-weight:700;\r\n                                            text-transform:uppercase;\r\n                                            line-height:16px;\r\n                                            font-size:16px;\r\n                                            background-color:#ffea28;\r\n                                            padding:12px 18px;\"\r\n                                            moz-do-not-send=\"true\">VER\r\n                                            LOS PRODUCTOS</a> </td>\r\n                                        <td width=\"15\"> </td>\r\n                                      </tr>\r\n                                    </tbody>\r\n                                  </table>\r\n                                </td>\r\n                              </tr>\r\n                              <tr>\r\n                                <td style=\"display:block;height:40px;\"\r\n                                  width=\"100%\" height=\"40\"> </td>\r\n                              </tr>\r\n                            </tbody>\r\n                          </table>\r\n                        </td>\r\n                      </tr>\r\n                    </tbody>\r\n                  </table>\r\n                </td>\r\n              </tr>\r\n            </tbody>\r\n          </table>\r\n        </div>\r\n      </div>\r\n      <!--[if (gte mso 9)|(IE)]>    </td>  </tr> </table> <![endif]-->\r\n      <!--[if (gte mso 9)|(IE)]> <table align=\"center\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"650\">  <tr>    <td align=\"center\" valign=\"top\" width=\"650\">      <![endif]-->\r\n      <div class=\"content\" style=\"max-width:650px; margin: 0 auto\">\r\n        <table width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\"\r\n          bgcolor=\"#ffffff\">\r\n          <tbody>\r\n            <tr>\r\n              <td height=\"20\"><br>\r\n              </td>\r\n            </tr>\r\n          </tbody>\r\n        </table>\r\n      </div>\r\n      <!--[if (gte mso 9)|(IE)]>     </td>   </tr> </table> <![endif]-->\r\n      <!--[if (gte mso 9)|(IE)]> <table align=\"center\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"650\">  <tr>    <td align=\"center\" valign=\"top\" width=\"650\">      <![endif]-->\r\n      <div class=\"content\" style=\"max-width:650px; margin: 0 auto\">\r\n        <table width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\"\r\n          bgcolor=\"#ffffff\">\r\n          <tbody>\r\n            <tr>\r\n              <td height=\"20\"><br>\r\n              </td>\r\n            </tr>\r\n          </tbody>\r\n        </table>\r\n      </div>\r\n      <!--[if (gte mso 9)|(IE)]>     </td>   </tr> </table> <![endif]--><!--[if (gte mso 9)|(IE)]> <table align=\"center\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"650\">  <tr>    <td align=\"center\" valign=\"top\" width=\"650\">      <![endif]-->\r\n      <div class=\"content\" style=\"max-width:650px; margin: 0 auto\">\r\n        <div>\r\n          <table cellspacing=\"0\" cellpadding=\"0\" border=\"0\"\r\n            bgcolor=\"#ffffff\" align=\"center\">\r\n            <tbody>\r\n              <tr>\r\n                <td style=\"max-width:295px; width:49.16666666666667%;\"\r\n                  valign=\"top\">\r\n                  <table class=\"product product_inside\" cellspacing=\"0\"\r\n                    cellpadding=\"0\" border=\"0\">\r\n                    <tbody>\r\n                      <tr>\r\n                        <td> <a style=\"display:block;\"\r\nhref=\"http://click.email.decathlon.es/?qs=509a9c8079e838f0386321b24addbb9ec26a44b7323de38d08271722f91350027a8218c9612ef13edaa1bcc5fc554b91eac36361dc9503532093d7f243dc1a83\"\r\n                            title=\"Decathlon\" moz-do-not-send=\"true\"> <img\r\nsrc=\"http://pictures.decathlon.spain.s3.amazonaws.com/opco_vad_cast_02102020/img_06.jpg\"\r\n                              alt=\"Decathlon\"\r\n                              style=\"display:block;width:100%;\r\n                              height:auto;\" moz-do-not-send=\"true\"\r\n                              border=\"0\"> </a> </td>\r\n                      </tr>\r\n                      <tr>\r\n                        <td>\r\n                          <table cellspacing=\"0\" cellpadding=\"0\"\r\n                            border=\"0\">\r\n                            <tbody>\r\n                              <tr>\r\n                                <td align=\"center\">\r\n                                  <table cellspacing=\"0\" cellpadding=\"0\"\r\n                                    border=\"0\">\r\n                                    <tbody>\r\n                                      <tr>\r\n                                        <td width=\"15\"> </td>\r\n                                        <td class=\"info_product\"\r\n                                          align=\"center\">\r\n                                          <h1\r\n                                            style=\"margin:0;line-height:30px;\r\n                                            font-size:25px;\r\n                                            text-transform:uppercase;font-weight:\r\n                                            300;\"><a\r\nhref=\"http://click.email.decathlon.es/?qs=509a9c8079e838f0386321b24addbb9ec26a44b7323de38d08271722f91350027a8218c9612ef13edaa1bcc5fc554b91eac36361dc9503532093d7f243dc1a83\"\r\n                                              title=\"Decathlon\"\r\n                                              style=\"text-decoration:none;\r\ncolor:#4d4d4d;line-height:30px; font-size:25px;\r\n                                              text-transform:uppercase;font-weight:\r\n                                              300;\"\r\n                                              moz-do-not-send=\"true\"><strong><span\r\n                                                  style=\"display: block;\r\n                                                  margin-top: 15px;\">ZAPATILLAS\r\n                                                  CAMINAR</span></strong></a></h1>\r\n                                          <div style=\"margin-top:\r\n                                            10px;margin-bottom:\r\n                                            20px;text-align: center;\"> </div>\r\n                                          <a\r\nhref=\"http://click.email.decathlon.es/?qs=509a9c8079e838f0386321b24addbb9ec26a44b7323de38d08271722f91350027a8218c9612ef13edaa1bcc5fc554b91eac36361dc9503532093d7f243dc1a83\"\r\n                                            class=\"button\" title=\"VER\r\n                                            LOS PRODUCTOS\"\r\n                                            style=\"text-decoration:none;\r\n                                            color:#000; font-weight:700;\r\n                                            text-transform:uppercase;\r\n                                            line-height:16px;\r\n                                            font-size:16px;\r\n                                            background-color:#ffea28;\r\n                                            padding:12px 18px;\"\r\n                                            moz-do-not-send=\"true\">VER\r\n                                            LOS PRODUCTOS</a> </td>\r\n                                        <td width=\"15\"> </td>\r\n                                      </tr>\r\n                                    </tbody>\r\n                                  </table>\r\n                                </td>\r\n                              </tr>\r\n                              <tr>\r\n                                <td style=\"display:block;height:40px;\"\r\n                                  width=\"100%\" height=\"40\"> </td>\r\n                              </tr>\r\n                            </tbody>\r\n                          </table>\r\n                        </td>\r\n                      </tr>\r\n                    </tbody>\r\n                  </table>\r\n                </td>\r\n                <td class=\"space\" style=\"width:1.666666666666667%;\r\n                  min-width:10px;\"><br>\r\n                </td>\r\n                <td style=\"max-width:295px; width:49.16666666666667%;\"\r\n                  valign=\"top\">\r\n                  <table class=\"product product_inside\" cellspacing=\"0\"\r\n                    cellpadding=\"0\" border=\"0\">\r\n                    <tbody>\r\n                      <tr>\r\n                        <td> <a style=\"display:block;\"\r\nhref=\"http://click.email.decathlon.es/?qs=509a9c8079e838f027b0060c1ad4a72871af3ea7b64f83a2d8958f368c90059396e739b661358f4506f779d4e343622fe82261b98288416e458a87611fe9acd1\"\r\n                            title=\"Decathlon\" moz-do-not-send=\"true\"> <img\r\nsrc=\"http://pictures.decathlon.spain.s3.amazonaws.com/opco_vad_cast_02102020/img_07.jpg\"\r\n                              alt=\"Decathlon\"\r\n                              style=\"display:block;width:100%;\r\n                              height:auto;\" moz-do-not-send=\"true\"\r\n                              border=\"0\"> </a> </td>\r\n                      </tr>\r\n                      <tr>\r\n                        <td>\r\n                          <table cellspacing=\"0\" cellpadding=\"0\"\r\n                            border=\"0\">\r\n                            <tbody>\r\n                              <tr>\r\n                                <td align=\"center\">\r\n                                  <table cellspacing=\"0\" cellpadding=\"0\"\r\n                                    border=\"0\">\r\n                                    <tbody>\r\n                                      <tr>\r\n                                        <td width=\"15\"> </td>\r\n                                        <td class=\"info_product\"\r\n                                          align=\"center\">\r\n                                          <h1\r\n                                            style=\"margin:0;line-height:30px;\r\n                                            font-size:25px;\r\n                                            text-transform:uppercase;font-weight:\r\n                                            300\"><a\r\nhref=\"http://click.email.decathlon.es/?qs=509a9c8079e838f027b0060c1ad4a72871af3ea7b64f83a2d8958f368c90059396e739b661358f4506f779d4e343622fe82261b98288416e458a87611fe9acd1\"\r\n                                              title=\"Decathlon\"\r\n                                              style=\"text-decoration:none;\r\ncolor:#4d4d4d;line-height:30px; font-size:25px;\r\n                                              text-transform:uppercase;\r\n                                              font-weight: 300\"\r\n                                              moz-do-not-send=\"true\"><strong><span\r\n                                                  style=\"display: block;\r\n                                                  margin-top: 15px;\">ZAPATILLAS\r\n                                                  TENIS</span></strong></a></h1>\r\n                                          <div style=\"margin-top:\r\n                                            10px;margin-bottom:\r\n                                            20px;text-align: center;\"> </div>\r\n                                          <a\r\nhref=\"http://click.email.decathlon.es/?qs=509a9c8079e838f027b0060c1ad4a72871af3ea7b64f83a2d8958f368c90059396e739b661358f4506f779d4e343622fe82261b98288416e458a87611fe9acd1\"\r\n                                            class=\"button\" title=\"VER\r\n                                            LOS PRODUCTOS\"\r\n                                            style=\"text-decoration:none;\r\n                                            color:#000; font-weight:700;\r\n                                            text-transform:uppercase;\r\n                                            line-height:16px;\r\n                                            font-size:16px;\r\n                                            background-color:#ffea28;\r\n                                            padding:12px 18px;\"\r\n                                            moz-do-not-send=\"true\">VER\r\n                                            LOS PRODUCTOS</a> </td>\r\n                                        <td width=\"15\"> </td>\r\n                                      </tr>\r\n                                    </tbody>\r\n                                  </table>\r\n                                </td>\r\n                              </tr>\r\n                              <tr>\r\n                                <td style=\"display:block;height:40px;\"\r\n                                  width=\"100%\" height=\"40\"> </td>\r\n                              </tr>\r\n                            </tbody>\r\n                          </table>\r\n                        </td>\r\n                      </tr>\r\n                    </tbody>\r\n                  </table>\r\n                </td>\r\n              </tr>\r\n            </tbody>\r\n          </table>\r\n        </div>\r\n      </div>\r\n      <!--[if (gte mso 9)|(IE)]>    </td>  </tr> </table> <![endif]-->\r\n      <!--[if (gte mso 9)|(IE)]> <table align=\"center\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"650\">  <tr>    <td align=\"center\" valign=\"top\" width=\"650\">      <![endif]-->\r\n      <div class=\"content\" style=\"max-width:650px; margin: 0 auto\">\r\n        <table width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\"\r\n          bgcolor=\"#ffffff\">\r\n          <tbody>\r\n            <tr>\r\n              <td height=\"20\"><br>\r\n              </td>\r\n            </tr>\r\n          </tbody>\r\n        </table>\r\n      </div>\r\n      <!--[if (gte mso 9)|(IE)]>     </td>   </tr> </table> <![endif]-->\r\n      <!--[if (gte mso 9)|(IE)]> <table align=\"center\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"650\">  <tr>    <td align=\"center\" valign=\"top\" width=\"650\">      <![endif]-->\r\n      <div class=\"content\" style=\"max-width:650px; margin: 0 auto\">\r\n        <table width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\"\r\n          bgcolor=\"#ffffff\">\r\n          <tbody>\r\n            <tr>\r\n              <td height=\"20\"><br>\r\n              </td>\r\n            </tr>\r\n          </tbody>\r\n        </table>\r\n      </div>\r\n      <!--[if (gte mso 9)|(IE)]>     </td>   </tr> </table> <![endif]--><!--[if (gte mso 9)|(IE)]> <table align=\"center\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"650\">   <tr>     <td align=\"center\" valign=\"top\" width=\"650\">     <![endif]-->\r\n      <div class=\"content\" style=\"max-width:650px; margin: 0 auto\">\r\n        <table cellspacing=\"0\" cellpadding=\"0\" border=\"0\">\r\n          <tbody>\r\n            <tr>\r\n              <td align=\"center\">\r\n                <!--[if !mso]><!--> <a\r\nhref=\"http://click.email.decathlon.es/?qs=509a9c8079e838f03b8ea80513de363989ca2f7fc41d9b29c93dfb31f9c5a9d02fe449e8f0b2849c17ec9852d73bdcbe2212f54755a5269470b079cba24e1de6\"\r\n                  target=\"_blank\" title=\"DECATHLON\"\r\n                  moz-do-not-send=\"true\"> <img class=\"just_mobile\"\r\nsrc=\"http://pictures.decathlon.spain.s3.amazonaws.com/opco_vad_cast_02102020/img_01_app.gif\"\r\n                    alt=\"DECATHLON\" style=\"width: 0; max-height: 0;\r\n                    overflow: hidden; float:left\" moz-do-not-send=\"true\"\r\n                    border=\"0\"> </a>\r\n                <!--<![endif]--> <a\r\nhref=\"http://click.email.decathlon.es/?qs=509a9c8079e838f03b8ea80513de363989ca2f7fc41d9b29c93dfb31f9c5a9d02fe449e8f0b2849c17ec9852d73bdcbe2212f54755a5269470b079cba24e1de6\"\r\n                  target=\"_blank\" title=\"DECATHLON\"\r\n                  moz-do-not-send=\"true\"> <img class=\"no_mobile\"\r\nsrc=\"http://pictures.decathlon.spain.s3.amazonaws.com/opco_vad_cast_02102020/img-envio-devoluciones-es.jpg\"\r\n                    alt=\"DECATHLON\" style=\"display:block;width:100%;\r\n                    height:auto;\" moz-do-not-send=\"true\" border=\"0\"> </a>\r\n              </td>\r\n            </tr>\r\n          </tbody>\r\n        </table>\r\n      </div>\r\n      <!--[if (gte mso 9)|(IE)]>     </td>   </tr> </table> <![endif]-->\r\n      <!--[if (gte mso 9)|(IE)]> <table align=\"center\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"650\">  <tr>    <td align=\"center\" valign=\"top\" width=\"650\">      <![endif]-->\r\n      <div class=\"content\" style=\"max-width:650px; margin: 0 auto\">\r\n        <table width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\"\r\n          bgcolor=\"#ffffff\">\r\n          <tbody>\r\n            <tr>\r\n              <td height=\"20\"><br>\r\n              </td>\r\n            </tr>\r\n          </tbody>\r\n        </table>\r\n      </div>\r\n      <!--[if (gte mso 9)|(IE)]>     </td>   </tr> </table> <![endif]--><!--[if (gte mso 9)|(IE)]> <table align=\"center\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"650\">   <tr>     <td align=\"center\" valign=\"top\" width=\"650\">       <![endif]-->\r\n      <div class=\"content\" style=\"max-width:650px; margin: 0 auto\">\r\n        <table class=\"just_mobile\" style=\"display: none\" cellspacing=\"0\"\r\n          cellpadding=\"0\" border=\"0\" align=\"center\">\r\n          <tbody>\r\n            <tr>\r\n              <td width=\"50%\" align=\"center\"><a\r\nhref=\"http://click.email.decathlon.es/?qs=509a9c8079e838f0d853e46f95cb56ff78012c2c89e8b8de40f4c9a2683fef8ff52b8167f4bcb0ba1a8987aa2c4a701e5ffca30d7a77a23734a791607e162313\"\r\n                  moz-do-not-send=\"true\"><img\r\nsrc=\"http://pictures.decathlon.spain.s3.amazonaws.com/opco_vad_cast_02102020/click-recoge-mobile.gif\"\r\n                    alt=\"Recogida en tienda gratuita\"\r\n                    style=\"display:block\" moz-do-not-send=\"true\"\r\n                    border=\"0\"></a></td>\r\n              <td width=\"50%\" align=\"center\"><a\r\nhref=\"http://click.email.decathlon.es/?qs=509a9c8079e838f0d853e46f95cb56ff78012c2c89e8b8de40f4c9a2683fef8ff52b8167f4bcb0ba1a8987aa2c4a701e5ffca30d7a77a23734a791607e162313\"\r\n                  moz-do-not-send=\"true\"><img\r\nsrc=\"http://pictures.decathlon.spain.s3.amazonaws.com/opco_vad_cast_02102020/transporte-gratuito-mobile.gif\"\r\n                    alt=\"Transporte gratuito a partir de 20 € de compra\"\r\n                    style=\"display:block\" moz-do-not-send=\"true\"\r\n                    border=\"0\"></a></td>\r\n            </tr>\r\n          </tbody>\r\n        </table>\r\n        <table class=\"just_mobile\" style=\"display: none\" cellspacing=\"0\"\r\n          cellpadding=\"0\" border=\"0\" align=\"center\">\r\n          <tbody>\r\n            <tr>\r\n              <td width=\"50%\" align=\"center\"><a\r\nhref=\"http://click.email.decathlon.es/?qs=509a9c8079e838f0a29458f717707a38dbaf53f226b7e56072933d2226ccb0571c58ebcecfbd6cd1e8b8c53baeecdca7433ebbc8a30312a0ffca8f88b5814a99\"\r\n                  moz-do-not-send=\"true\"><img\r\nsrc=\"http://pictures.decathlon.spain.s3.amazonaws.com/opco_vad_cast_02102020/cambios-devoluciones-mobile.gif\"\r\n                    alt=\"Cambios y devoluciones gratuitos\"\r\n                    style=\"display:block\" moz-do-not-send=\"true\"\r\n                    border=\"0\"></a></td>\r\n              <td width=\"50%\" align=\"center\"><a\r\nhref=\"http://click.email.decathlon.es/?qs=509a9c8079e838f017b0156c2ccc86274791394603d37e42430f703d18fa21f9473701b41c624e0628650b799bc86bee28fbb069da3bb01f08ca271fb06f7a62\"\r\n                  moz-do-not-send=\"true\"><img\r\nsrc=\"http://pictures.decathlon.spain.s3.amazonaws.com/opco_vad_cast_02102020/ayuda-mobile.gif\"\r\n                    alt=\"¿Necesitas ayuda?\" style=\"display:block\"\r\n                    moz-do-not-send=\"true\" border=\"0\"></a></td>\r\n            </tr>\r\n          </tbody>\r\n        </table>\r\n      </div>\r\n      <!--[if (gte mso 9)|(IE)]>     </td>   </tr> </table> <![endif]-->\r\n      <table width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\">\r\n        <tbody>\r\n          <tr>\r\n            <td height=\"20\"><br>\r\n            </td>\r\n          </tr>\r\n        </tbody>\r\n      </table>\r\n      <!--[if (gte mso 9)|(IE)]> <table align=\"center\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"650\">   <tr>     <td align=\"center\" valign=\"top\" width=\"650\">       <![endif]-->\r\n      <div class=\"content\" style=\"max-width:650px; margin: 0 auto\">\r\n        <table style=\"margin: 0 auto\" class=\"no_mobile\" width=\"650\"\r\n          cellspacing=\"0\" cellpadding=\"0\" border=\"0\" align=\"center\">\r\n          <tbody>\r\n            <tr>\r\n              <td> <a\r\nhref=\"http://click.email.decathlon.es/?qs=509a9c8079e838f0d853e46f95cb56ff78012c2c89e8b8de40f4c9a2683fef8ff52b8167f4bcb0ba1a8987aa2c4a701e5ffca30d7a77a23734a791607e162313\"\r\n                  target=\"_blank\" moz-do-not-send=\"true\"><img\r\nsrc=\"http://pictures.decathlon.spain.s3.amazonaws.com/opco_vad_cast_02102020/click-recoge-desktop.gif\"\r\n                    alt=\"Recogida en tienda gratuita\"\r\n                    style=\"display:block\" moz-do-not-send=\"true\"\r\n                    border=\"0\"></a> </td>\r\n              <td> <a\r\nhref=\"http://click.email.decathlon.es/?qs=509a9c8079e838f0d853e46f95cb56ff78012c2c89e8b8de40f4c9a2683fef8ff52b8167f4bcb0ba1a8987aa2c4a701e5ffca30d7a77a23734a791607e162313\"\r\n                  target=\"_blank\" moz-do-not-send=\"true\"><img\r\nsrc=\"http://pictures.decathlon.spain.s3.amazonaws.com/opco_vad_cast_02102020/transporte-gratuito-desktop.gif\"\r\n                    alt=\"Transporte gratuito a partir de 20 € de compra\"\r\n                    style=\"display:block\" moz-do-not-send=\"true\"\r\n                    border=\"0\"></a> </td>\r\n              <td> <a\r\nhref=\"http://click.email.decathlon.es/?qs=509a9c8079e838f0a29458f717707a38dbaf53f226b7e56072933d2226ccb0571c58ebcecfbd6cd1e8b8c53baeecdca7433ebbc8a30312a0ffca8f88b5814a99\"\r\n                  target=\"_blank\" moz-do-not-send=\"true\"><img\r\nsrc=\"http://pictures.decathlon.spain.s3.amazonaws.com/opco_vad_cast_02102020/cambios-devoluciones-desktop.gif\"\r\n                    alt=\"Cambios y devoluciones gratuitos\"\r\n                    style=\"display:block\" moz-do-not-send=\"true\"\r\n                    border=\"0\"></a> </td>\r\n              <td> <a\r\nhref=\"http://click.email.decathlon.es/?qs=509a9c8079e838f017b0156c2ccc86274791394603d37e42430f703d18fa21f9473701b41c624e0628650b799bc86bee28fbb069da3bb01f08ca271fb06f7a62\"\r\n                  target=\"_blank\" moz-do-not-send=\"true\"><img\r\nsrc=\"http://pictures.decathlon.spain.s3.amazonaws.com/opco_vad_cast_02102020/ayuda-desktop.gif\"\r\n                    alt=\"¿Necesitas ayuda?\" style=\"display:block\"\r\n                    moz-do-not-send=\"true\" border=\"0\"></a> </td>\r\n            </tr>\r\n          </tbody>\r\n        </table>\r\n      </div>\r\n      <!--[if (gte mso 9)|(IE)]>     </td>   </tr> </table> <![endif]-->\r\n      <table class=\"no_mobile\" width=\"100%\" cellspacing=\"0\"\r\n        cellpadding=\"0\" border=\"0\">\r\n        <tbody>\r\n          <tr>\r\n            <td height=\"20\"><br>\r\n            </td>\r\n          </tr>\r\n        </tbody>\r\n      </table>\r\n      <!--[if (gte mso 9)|(IE)]> <table align=\"center\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"650\" class=\"no_mobile\">   <tr>     <td align=\"center\" valign=\"top\" width=\"650\">       <![endif]-->\r\n      <div class=\"content\" style=\"max-width:650px; margin: 0 auto\">\r\n        <table class=\"no_mobile\" id=\"decathlon-services\" style=\"width:\r\n          100%; border-collapse: collapse;\" cellspacing=\"0\"\r\n          cellpadding=\"0\" border=\"0\" bgcolor=\"e8e8e8\" align=\"center\">\r\n          <tbody>\r\n            <tr>\r\n              <td style=\"padding: 10px; border-collapse: collapse;\"\r\n                bgcolor=\"e8e8e8\">\r\n                <table style=\"width: 100%; border-collapse: collapse;\"\r\n                  cellspacing=\"0\" cellpadding=\"0\" border=\"0\"\r\n                  align=\"center\">\r\n                  <tbody>\r\n                    <tr>\r\n                      <td style=\"border-collapse: collapse;\"\r\n                        valign=\"center\" align=\"center\"> <a\r\nhref=\"http://click.email.decathlon.es/?qs=509a9c8079e838f0b0987f46f57dbe829161c9cb8253b011f5b1e607f37702770d35be1041c1da727fc652a5980eb520bc4d0703eab7952f5b5eae7f7d72269c\"\r\n                          style=\"text-decoration: none;color: #000001;\"\r\n                          moz-do-not-send=\"true\">My Decathlon</a> </td>\r\n                      <td style=\"border-collapse: collapse;\"\r\n                        valign=\"center\" align=\"center\"> <a\r\nhref=\"http://click.email.decathlon.es/?qs=509a9c8079e838f03bc787856878b6e0804e999d5ef740c94d195d4cf7adabd17cd33180cb11df222f9df43a6f6c17f08007355141dcb83d217837a712165687\"\r\n                          style=\"text-decoration: none;color: #000001;\"\r\n                          moz-do-not-send=\"true\">Experiencia deportiva</a>\r\n                      </td>\r\n                      <td style=\"border-collapse: collapse;\"\r\n                        valign=\"center\" align=\"center\"> <a\r\nhref=\"http://click.email.decathlon.es/?qs=509a9c8079e838f04bc1149b320e45abfe8dbec51fd0b5bd9581a6fb1c356234650006acc11a9110b8dc6c3a10b16f2db27b6e5b7769e08d2766f352ee830345\"\r\n                          style=\"text-decoration: none;color: #000001;\"\r\n                          moz-do-not-send=\"true\">Seguros</a> </td>\r\n                      <td style=\"border-collapse: collapse;\"\r\n                        valign=\"center\" align=\"center\"> <a\r\nhref=\"http://click.email.decathlon.es/?qs=509a9c8079e838f073af25441eedbb0c82a0f869d26b882cc37fb8bedd93e14f1f4b387c33441b1398a1b27db115d5e9754a8e35fb78175b70238ebea3456ed6\"\r\n                          style=\"text-decoration: none;color: #000001;\"\r\n                          moz-do-not-send=\"true\">Financiación</a> </td>\r\n                      <td style=\"border-collapse: collapse;\"\r\n                        valign=\"center\" align=\"center\"> <a\r\nhref=\"http://click.email.decathlon.es/?qs=509a9c8079e838f00124833055c09f0683840db86058d52f62e1f827fea9e4d034154aaeed2bee871ae1a411069ed204000b3f058355b7edca42026d7ccce62e\"\r\n                          style=\"text-decoration: none;color: #000001;\"\r\n                          moz-do-not-send=\"true\">SPV</a> </td>\r\n                      <td style=\"border-collapse: collapse;\"\r\n                        valign=\"center\" align=\"center\"> <a\r\nhref=\"http://click.email.decathlon.es/?qs=509a9c8079e838f0dc76b080b2923a0027fc9e89d0273ae4d8b025ea17376d664eae43d9d086a230b4ddd17976e56b06515a4f01e3b4893d7287fd12e9edd18b\"\r\n                          style=\"text-decoration: none;color: #000001;\"\r\n                          moz-do-not-send=\"true\">Decathlon Ocasión</a> </td>\r\n                    </tr>\r\n                  </tbody>\r\n                </table>\r\n              </td>\r\n            </tr>\r\n          </tbody>\r\n        </table>\r\n      </div>\r\n      <!--[if (gte mso 9)|(IE)]>     </td>   </tr> </table> <![endif]-->\r\n      <table class=\"just_mobile\" style=\"display: none\" width=\"100%\"\r\n        cellspacing=\"0\" cellpadding=\"0\" border=\"0\">\r\n        <tbody>\r\n          <tr>\r\n            <td height=\"20\"><br>\r\n            </td>\r\n          </tr>\r\n        </tbody>\r\n      </table>\r\n      <!--[if (gte mso 9)|(IE)]> <table align=\"center\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"650\">   <tr>     <td align=\"center\" valign=\"top\" width=\"650\">       <![endif]-->\r\n      <div class=\"content\" style=\"max-width:650px; margin: 0 auto\">\r\n        <table class=\"just_mobile\" style=\"display: none; width: 100%;\r\n          border-collapse: collapse;\" cellspacing=\"0\" cellpadding=\"0\"\r\n          border=\"0\" align=\"center\">\r\n          <style type=\"text/css\">\r\n#decathlon-menu a { font-size: 18px; }\r\n#decathlon-menu td { padding-left: 15px; }\r\n#decathlon-menu td.no-padding { padding-left: 0; }\r\n</style><tbody>\r\n            <tr>\r\n              <td>\r\n                <table id=\"decathlon-menu\" width=\"100%\" cellspacing=\"0\"\r\n                  cellpadding=\"0\" border=\"0\">\r\n                  <tbody>\r\n                    <tr>\r\n                      <td class=\"no-padding\" style=\"padding-left: 0;\"\r\n                        align=\"center\"><a\r\nhref=\"http://click.email.decathlon.es/?qs=509a9c8079e838f07648139b524c5009df37ea827e4f5bf7c36b409032a24a891a01e7ec76bbe5bae77e87e0307e767fc3da82af84a00d2a2eff3242584bd8e7\"\r\n                          style=\"display: block;text-decoration:\r\n                          none;text-transform: uppercase;color:\r\n                          #706f6f;font-size: 18px;\"\r\n                          moz-do-not-send=\"true\">Deportes</a></td>\r\n                      <td style=\"padding-left: 15px;\" align=\"center\"><a\r\nhref=\"http://click.email.decathlon.es/?qs=509a9c8079e838f06a9e2703fac9c435da33eb1154802430445f4c17d4b720347f495a3d63e9f838dc3f5492f4d3f1c0e2939b6383c71aac55726cde557577c7\"\r\n                          style=\"display: block;text-decoration:\r\n                          none;text-transform: uppercase;color:\r\n                          #706f6f;font-size: 18px;\"\r\n                          moz-do-not-send=\"true\">Mujer</a></td>\r\n                      <td style=\"padding-left: 15px;\" align=\"center\"><a\r\nhref=\"http://click.email.decathlon.es/?qs=509a9c8079e838f0b82519693706f5c25858d6be1d9ad55a50a4a6b204efc2efc8c41af575f0fdc2316ad414ab2b5bca445444fa6bf469e7155c75e89d7433ab\"\r\n                          style=\"display: block;text-decoration:\r\n                          none;text-transform: uppercase;color:\r\n                          #706f6f;font-size: 18px;\"\r\n                          moz-do-not-send=\"true\">Niños</a></td>\r\n                      <td style=\"padding-left: 15px;\" align=\"center\"><a\r\nhref=\"http://click.email.decathlon.es/?qs=509a9c8079e838f0536c88a577aee1c38275102f8ad0faec0cfd31c8b56e273dd67f16cfa6ac2671dce4094a56e120dbccd80d0b792f0e8e98a814abca3d5979\"\r\n                          style=\"display: block;text-decoration:\r\n                          none;text-transform: uppercase;color:\r\n                          #706f6f;font-size: 18px;\"\r\n                          moz-do-not-send=\"true\">Hombre</a></td>\r\n                      <td style=\"padding-left: 15px;\" align=\"center\"><a\r\nhref=\"http://click.email.decathlon.es/?qs=509a9c8079e838f0d20bb9cd492759ee7b0abb6830f588615c7b01dee9bfa9318870b364dd5400a7afb1563d65e39d8b9ca8ebe5384c6ca59631439c333a7057\"\r\n                          style=\"display: block;text-decoration:\r\n                          none;text-transform: uppercase;color:\r\n                          #706f6f;font-size: 18px;\"\r\n                          moz-do-not-send=\"true\">Accesorios</a></td>\r\n                      <td style=\"padding-left: 15px;\" align=\"center\"><a\r\nhref=\"http://click.email.decathlon.es/?qs=509a9c8079e838f067a43630bf6c320d46ff3d4256a5fb337c399cd0b5522bd445ca7f9e4ebe85836998813eb6f1d8275d0bde3dd26ac60cf7c96ed980265165\"\r\n                          style=\"display: block;text-decoration:\r\n                          none;text-transform: uppercase;color:\r\n                          #E20C18;font-size: 18px;\"\r\n                          moz-do-not-send=\"true\">Últimas unidades</a></td>\r\n                    </tr>\r\n                  </tbody>\r\n                </table>\r\n              </td>\r\n            </tr>\r\n          </tbody>\r\n        </table>\r\n      </div>\r\n      <!--[if (gte mso 9)|(IE)]>     </td>   </tr> </table> <![endif]-->\r\n      <table class=\"footer-wrap\" width=\"100%\" cellspacing=\"0\"\r\n        cellpadding=\"0\" border=\"0\">\r\n        <tbody>\r\n          <tr>\r\n            <td class=\"container\">\r\n              <table width=\"100%\" cellspacing=\"0\" cellpadding=\"0\"\r\n                border=\"0\">\r\n                <tbody>\r\n                  <tr>\r\n                    <td height=\"25\"><br>\r\n                    </td>\r\n                  </tr>\r\n                </tbody>\r\n              </table>\r\n              <div class=\"content-header\">\r\n                <table width=\"350\" cellspacing=\"0\" cellpadding=\"0\"\r\n                  border=\"0\" align=\"center\">\r\n                  <tbody>\r\n                    <tr>\r\n                      <td width=\"42\" align=\"center\"><a\r\nhref=\"http://click.email.decathlon.es/?qs=509a9c8079e838f05b6de1732e986cdbb247520ced4f2547f32ef9736bab560a7d2ffd141f2027b07463184d5cc4a3e71c5c6ce9ba7d5d6e6f0df9b50a1119e5\"\r\n                          rel=\"external\" target=\"_blank\"\r\n                          title=\"Facebook\" moz-do-not-send=\"true\"><img\r\nsrc=\"http://pictures.decathlon.spain.s3.amazonaws.com/opco_vad_cast_02102020/facebook.gif\"\r\n                            alt=\"Facebook\" style=\"display:block;\"\r\n                            moz-do-not-send=\"true\" width=\"21\"\r\n                            height=\"44\" border=\"0\"></a></td>\r\n                      <td class=\"space\" width=\"35\"><br>\r\n                      </td>\r\n                      <td width=\"42\" align=\"center\"><a\r\nhref=\"http://click.email.decathlon.es/?qs=509a9c8079e838f0f87ad27e179b611c6d1f64afa366dbe420a972100017e1c86dd2a2c0236c69e99fc6dd469b626553ca2eec4c9faff7f80f14bb12e60b0648\"\r\n                          rel=\"external\" target=\"_blank\" title=\"Youtube\"\r\n                          moz-do-not-send=\"true\"><img\r\nsrc=\"http://pictures.decathlon.spain.s3.amazonaws.com/opco_vad_cast_02102020/youtube.gif\"\r\n                            alt=\"Youtube\" style=\"display:block;\"\r\n                            moz-do-not-send=\"true\" width=\"42\"\r\n                            height=\"44\" border=\"0\"></a></td>\r\n                      <td class=\"space\" width=\"35\"><br>\r\n                      </td>\r\n                      <td width=\"42\" align=\"center\"><a\r\nhref=\"http://click.email.decathlon.es/?qs=509a9c8079e838f02749727e622c766716790c925b82710bd3c17f730d8a4cccf536699b01621f22e636f9f8e89eb087d8e7eed14f5300adf547812c86406799\"\r\n                          rel=\"external\" target=\"_blank\"\r\n                          title=\"Instagram\" moz-do-not-send=\"true\"><img\r\nsrc=\"http://pictures.decathlon.spain.s3.amazonaws.com/opco_vad_cast_02102020/instagram.gif\"\r\n                            alt=\"Instagram\" style=\"display:block;\"\r\n                            moz-do-not-send=\"true\" width=\"42\"\r\n                            height=\"44\" border=\"0\"></a></td>\r\n                      <td class=\"space\" width=\"35\"><br>\r\n                      </td>\r\n                      <td width=\"42\" align=\"center\"><a\r\nhref=\"http://click.email.decathlon.es/?qs=509a9c8079e838f04407a2c4ce67b1b484720c4400d43c740d40dc3b9ecc6778f6135a8652bf55867b492fc2302ae1b45db9dd3d781cbb0f0dde7d6a80840626\"\r\n                          rel=\"external\" target=\"_blank\" title=\"Twitter\"\r\n                          moz-do-not-send=\"true\"><img\r\nsrc=\"http://pictures.decathlon.spain.s3.amazonaws.com/opco_vad_cast_02102020/twitter.gif\"\r\n                            alt=\"Twitter\" style=\"display:block;\"\r\n                            moz-do-not-send=\"true\" width=\"41\"\r\n                            height=\"44\" border=\"0\"></a></td>\r\n                      <td class=\"space\" width=\"35\"><br>\r\n                      </td>\r\n                      <td width=\"48\"><a\r\nhref=\"http://click.email.decathlon.es/?qs=509a9c8079e838f0b6cde3d01ee99b419a72b093f2110d61ce6254be57511ff2b63c461f36db2d0c43fc878ff67b7b6fdf694db07db6a84f5610f1a41c1a9f5a\"\r\n                          rel=\"external\" target=\"_blank\"\r\n                          title=\"Comunidad Decathlon\"\r\n                          moz-do-not-send=\"true\"><img\r\nsrc=\"http://pictures.decathlon.spain.s3.amazonaws.com/opco_vad_cast_02102020/comunidad.gif\"\r\n                            alt=\"Comunidad Decathlon\"\r\n                            style=\"display:block;\"\r\n                            moz-do-not-send=\"true\" width=\"48\"\r\n                            height=\"44\" border=\"0\"></a></td>\r\n                    </tr>\r\n                  </tbody>\r\n                </table>\r\n              </div>\r\n            </td>\r\n          </tr>\r\n        </tbody>\r\n      </table>\r\n      <!--[if (gte mso 9)|(IE)]>  <table align=\"center\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"650\" class=\"no_mobile\">   <tr>    <td align=\"center\" valign=\"top\" width=\"650\">     <![endif]-->\r\n      <div class=\"content\" style=\"max-width:650px; margin: 0 auto\">\r\n        <table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" align=\"center\">\r\n          <tbody>\r\n            <tr>\r\n              <td style=\"color:#89878C; font-family:Arial, Helvetica,\r\n                sans-serif; font-size:11px; text-align:center;\r\n                line-height:13px;text-align:center;\r\n                text-decoration:none;\" bgcolor=\"#ffffff\">\r\n                <p style=\"text-align:center;margin-top:20px;\">Para no\r\n                  recibir más emails, pincha <a\r\nhref=\"http://click.email.decathlon.es/?qs=509a9c8079e838f0183358ff026d029197d90db41b93813b41332ae6a683c328daba5348f65f951c1b85aea62a1a5a02ee74c7b5462d3dbc6b960ce5956575a4\"\r\n                    target=\"_blank\" style=\"color:#706f6f;\"\r\n                    moz-do-not-send=\"true\">aquí</a></p>\r\n              </td>\r\n            </tr>\r\n            <tr>\r\n              <td style=\"color:#89878C; font-family:Arial, Helvetica,\r\n                sans-serif; font-size:11px; text-align:\r\n                justify;padding:20px;line-height:13px;\"\r\n                bgcolor=\"#ffffff\">\r\n                <p style=\"margin-bottom: 10px;\">Dado que utilizamos\r\n                  proveedores externos para los envíos, y las bases de\r\n                  datos enviadas se actualizan cada 24 hrs., es posible\r\n                  que puedas aún recibir alguna comunicación nuestra que\r\n                  ya estuviera en marcha.</p>\r\n                <p style=\"margin-bottom: 10px;\">* Consulta los métodos,\r\n                  plazos y gastos de envío disponibles en el siguiente <a\r\nhref=\"http://click.email.decathlon.es/?qs=509a9c8079e838f0deef26fc6c25b998058e1f7a3a2d0c53dcccfec8756b80a89396c41553c6e33ee4fe79fd86d3625c2fd71d2defc86a243a71458af388442b\"\r\n                    title=\"tabla\" target=\"_blank\" style=\"color:#706f6f;\"\r\n                    moz-do-not-send=\"true\">enlace</a>. <br>\r\n                  <br>\r\n                  ** Los precios de venta de los artículos de nuestro\r\n                  catálogo incluyen IVA. Los precios para las entregas\r\n                  con destino a Canarias, Ceuta, Melilla y Andorra\r\n                  incluyen impuestos indirectos. Los precios de venta de\r\n                  los artículos de nuestro catálogo son los recomendados\r\n                  desde central a día de ayer. Gastos de envío no\r\n                  incluidos. Fotos de los productos no contractuales.</p>\r\n                <p style=\"margin-bottom: 10px;\">Se informa a los\r\n                  destinatarios del presente correo electrónico de\r\n                  tratamiento de sus datos por parte de Decathlon\r\n                  España, S.A.U. CIF: A-79935607 C/ Salvador de\r\n                  Madariaga, s/n, Dehesa Vieja, 28702, San Sebastián de\r\n                  los Reyes, Madrid, que actúa como responsable del\r\n                  tratamiento. La base para el tratamiento de datos es\r\n                  el consentimiento para el envío de estas\r\n                  comunicaciones de su interés sobre nuestros productos\r\n                  y/o servicios. Los datos se conservarán mientras no se\r\n                  solicite su supresión y, en su caso, durante los\r\n                  plazos legales de aplicación. No se cederán datos a\r\n                  terceros, salvo obligación legal, ni están previstas\r\n                  transferencias internacionales de dichos datos. Los\r\n                  interesados pueden ejercitar sus derechos de acceso,\r\n                  rectificación, supresión, portabilidad y la limitación\r\n                  u oposición dirigiéndose por escrito a la dirección\r\n                  del Responsable, indicando “ejercicio derechos\r\n                  protección de datos” o a través de la siguiente\r\n                  dirección electrónica: <a\r\n                    href=\"mailto:servicio.usuario@decathlon.com\"\r\n                    style=\"color:#706f6f;\" moz-do-not-send=\"true\">servicio.usuario@decathlon.com</a>,\r\n                  así como a reclamar ante la Autoridad de Control\r\n                  (Agencia Española de Protección de Datos: <a\r\nhref=\"http://click.email.decathlon.es/?qs=509a9c8079e838f065ebb4e2213f16523eff79b7432e4c96be0471a2101c12cc5444771edb745e5e543de0718adeb37cc530908e5cf6c692acb6c158ff556bed\"\r\n                    style=\"color:#706f6f;\" moz-do-not-send=\"true\">www.agpd.es</a>).\r\n                  Puede obtener más información en <a\r\nhref=\"http://click.email.decathlon.es/?qs=509a9c8079e838f0759cbce74e35bd02a890cefcb15cc414ef0aa31fed65cedbe12d377158cd3fb5dab6e7c27980c3ff0762616aefb5fcaa37154e8ffd2725e0\"\r\n                    style=\"color:#706f6f;\" moz-do-not-send=\"true\">www.decathlon.es</a>.\r\n                  Contacto con protección de datos : <a\r\n                    href=\"mailto:delegadoprotecciondatos@decathlon.com\"\r\n                    style=\"color:#706f6f;\" moz-do-not-send=\"true\">delegadoprotecciondatos@decathlon.com</a></p>\r\n              </td>\r\n            </tr>\r\n            <tr>\r\n              <td height=\"20\"><br>\r\n              </td>\r\n            </tr>\r\n          </tbody>\r\n        </table>\r\n      </div>\r\n      <!--[if (gte mso 9)|(IE)]>    </td>   </tr>  </table>  <![endif]-->\r\n      <div id=\"DAB4FAD8-2DD7-40BB-A1B8-4E2AA1F9FDF2\"><br>\r\n        <table style=\"border-top: 1px solid #D3D4DE;\">\r\n          <tbody>\r\n            <tr>\r\n              <td style=\"width: 55px; padding-top: 18px;\"><a\r\nhref=\"http://www.avg.com/email-signature?utm_medium=email&amp;utm_source=link&amp;utm_campaign=sig-email&amp;utm_content=emailclient\"\r\n                  target=\"_blank\" moz-do-not-send=\"true\"><img\r\nsrc=\"https://ipmcdn.avast.com/images/icons/icon-envelope-tick-green-avg-v1.png\"\r\n                    alt=\"\" style=\"width: 46px; height: 29px;\"\r\n                    moz-do-not-send=\"true\" width=\"46\" height=\"29\"></a></td>\r\n              <td style=\"width: 470px; padding-top: 17px; color:\r\n                #41424e; font-size: 13px; font-family: Arial, Helvetica,\r\n                sans-serif; line-height: 18px;\">Libre de virus. <a\r\nhref=\"http://www.avg.com/email-signature?utm_medium=email&amp;utm_source=link&amp;utm_campaign=sig-email&amp;utm_content=emailclient\"\r\n                  target=\"_blank\" style=\"color: #4453ea;\"\r\n                  moz-do-not-send=\"true\">www.avg.com</a> </td>\r\n            </tr>\r\n          </tbody>\r\n        </table>\r\n        <a href=\"#DAB4FAD8-2DD7-40BB-A1B8-4E2AA1F9FDF2\" width=\"1\"\r\n          height=\"1\" moz-do-not-send=\"true\"> </a></div>\r\n    </div>\r\n  </body>\r\n</html>','',0,6);
/*!40000 ALTER TABLE `email` ENABLE KEYS */;


--
-- Definition of table `mime_type`
--

DROP TABLE IF EXISTS `mime_type`;
CREATE TABLE `mime_type` (
  `idmime_type` int(11) NOT NULL AUTO_INCREMENT,
  `Extension` varchar(10) NOT NULL,
  `Description` varchar(100) NOT NULL,
  `MimeType` varchar(100) NOT NULL,
  PRIMARY KEY (`idmime_type`)
) ENGINE=InnoDB AUTO_INCREMENT=63 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `mime_type`
--

/*!40000 ALTER TABLE `mime_type` DISABLE KEYS */;
INSERT INTO `mime_type` (`idmime_type`,`Extension`,`Description`,`MimeType`) VALUES 
 (1,'aac','Archivo de audio AAC','audio/aac'),
 (2,'abw','Documento AbiWord','application/x-abiword'),
 (3,'arc','Documento de Archivo (múltiples archivos incrustados)','application/octet-stream'),
 (4,'avi','AVI: Audio Video Intercalado','video/x-msvideo'),
 (5,'azw','Formato  eBook Amazon Kindle ','application/vnd.amazon.ebook'),
 (6,'bin','Cualquier tipo de datos binarios','application/octet-stream'),
 (7,'bz','Archivo BZip','application/x-bzip'),
 (8,'bz2','Archivo BZip2','application/x-bzip2'),
 (9,'csh','Script C-Shell','application/x-csh'),
 (10,'css','Hojas de estilo (CSS)','text/css'),
 (11,'csv','Valores separados por coma (CSV)','text/csv'),
 (12,'doc','Microsoft Word','application/msword'),
 (13,'epub','Publicación Electrónica (EPUB)','application/epub+zip'),
 (14,'gif','Graphics Interchange Format (GIF)','image/gif'),
 (15,'htm','Hipertexto (HTML)','text/html'),
 (16,'html','Hipertexto (HTML)','text/html'),
 (17,'ico','Formato Icon','image/x-icon'),
 (18,'ics','Formato iCalendar','text/calendar'),
 (19,'jar','Archivo Java (JAR)','application/java-archive'),
 (20,'jpeg','Imágenes JPEG','image/jpeg'),
 (21,'jpg','Imágenes JPEG','image/jpeg'),
 (22,'js','JavaScript (ECMAScript)','application/javascript'),
 (23,'json','Formato JSON','application/json'),
 (24,'mid','Interfaz Digital de Instrumentos Musicales (MIDI)','audio/midi'),
 (25,'midi','Interfaz Digital de Instrumentos Musicales (MIDI)','audio/midi'),
 (26,'mpeg','Video MPEG','video/mpeg'),
 (27,'mpkg','Paquete de instalación de Apple','application/vnd.apple.installer+xml'),
 (28,'odp','Documento de presentación de OpenDocument','application/vnd.oasis.opendocument.presentation'),
 (29,'ods','Hoja de Cálculo OpenDocument','application/vnd.oasis.opendocument.spreadsheet'),
 (30,'odt','Documento de texto OpenDocument','application/vnd.oasis.opendocument.text'),
 (31,'oga','Audio OGG','audio/ogg'),
 (32,'ogv','Video OGG','video/ogg'),
 (33,'ogx','OGG','application/ogg'),
 (34,'pdf','Adobe Portable Document Format (PDF)','application/pdf'),
 (35,'ppt','Microsoft PowerPoint','application/vnd.ms-powerpoint'),
 (36,'rar','Archivo RAR','application/x-rar-compressed'),
 (37,'rtf','Formato de Texto Enriquecido (RTF)','application/rtf'),
 (38,'sh','Script Bourne shell','application/x-sh'),
 (39,'svg','Gráficos Vectoriales (SVG)','image/svg+xml'),
 (40,'swf','Small web format (SWF) o Documento Adobe Flash','application/x-shockwave-flash'),
 (41,'tar','Aerchivo Tape (TAR)','application/x-tar'),
 (42,'tif','Formato de archivo de imagen etiquetado (TIFF)','image/tiff'),
 (43,'tiff','Formato de archivo de imagen etiquetado (TIFF)','image/tiff'),
 (44,'ttf','Fuente TrueType','font/ttf'),
 (45,'vsd','Microsft Visio','application/vnd.visio'),
 (46,'wav','Formato de audio de forma de onda (WAV)','audio/x-wav'),
 (47,'weba','Audio WEBM','audio/webm'),
 (48,'webm','Video WEBM','video/webm'),
 (49,'webp','Imágenes WEBP','image/webp'),
 (50,'woff','Formato de fuente abierta web (WOFF)','font/woff'),
 (51,'woff2','Formato de fuente abierta web (WOFF)','font/woff2'),
 (52,'xhtml','XHTML','application/xhtml+xml'),
 (53,'xls','Microsoft Excel','application/vnd.ms-excel'),
 (54,'xml','XML','application/xml'),
 (55,'xul','XUL','application/vnd.mozilla.xul+xml'),
 (56,'zip','Archivo ZIP','application/zip'),
 (57,'3gp','Contenedor de audio/video 3GPP','video/3gpp'),
 (58,'3g2','Contenedor de audio/video 3GPP2','video/3gpp2'),
 (59,'7z','Archivo 7-zip','application/x-7z-compressed'),
 (60,'docx','Microsoft Word','application/msword'),
 (61,'pptx','Microsoft PowerPoint','application/vnd.ms-powerpoint'),
 (62,'xlsx','Microsoft Excel','application/vnd.ms-excel');
/*!40000 ALTER TABLE `mime_type` ENABLE KEYS */;


--
-- Definition of table `postreader_settings`
--

DROP TABLE IF EXISTS `postreader_settings`;
CREATE TABLE `postreader_settings` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `TYPE` int(11) DEFAULT '1',
  `NAME` mediumtext,
  `USERNAME` mediumtext,
  `COOKIE` varchar(500) DEFAULT NULL,
  `SEARCH` mediumtext,
  `TABLENAME` varchar(300) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `postreader_settings`
--

/*!40000 ALTER TABLE `postreader_settings` DISABLE KEYS */;
INSERT INTO `postreader_settings` (`ID`,`TYPE`,`NAME`,`USERNAME`,`COOKIE`,`SEARCH`,`TABLENAME`) VALUES 
 (1,2,NULL,'admin',NULL,'{\"gridWidth\":621.4,\"thWidths\":{\"grid_headcell_icons\":26.4,\"grid_headcell_checkbox\":20.4,\"grid_headcell_field\":9.399999999999999,\"grid_headcell_field1\":31.4,\"grid_headcell_field2\":115.4,\"grid_headcell_field3\":79.4,\"grid_headcell_field4\":107.4,\"grid_headcell_field5\":155.4}}','users'),
 (2,2,NULL,'admin',NULL,'{\"gridWidth\":886,\"thWidths\":{\"grid_headcell_icons\":27,\"grid_headcell_checkbox\":22,\"grid_headcell_field\":10,\"grid_headcell_field1\":99,\"grid_headcell_field2\":138,\"grid_headcell_field3\":50,\"grid_headcell_field4\":90,\"grid_headcell_field5\":159,\"grid_headcell_field6\":98,\"grid_headcell_field7\":112}}','contact'),
 (3,2,NULL,'admin',NULL,'{\"gridWidth\":697.4,\"thWidths\":{\"grid_headcell_icons\":26.4,\"grid_headcell_checkbox\":20.4,\"grid_headcell_field\":12.399999999999999,\"grid_headcell_field1\":152.4,\"grid_headcell_field2\":438.4}}','config'),
 (4,2,NULL,'admin',NULL,'{\"gridWidth\":552.4,\"thWidths\":{\"grid_headcell_icons\":26.4,\"grid_headcell_checkbox\":20.4,\"grid_headcell_details\":33.4,\"grid_headcell_field\":9.399999999999999,\"grid_headcell_field1\":107.4,\"grid_headcell_field2\":298.4}}','super_catalog'),
 (5,3,'0','admin',NULL,'[\".dummyField\",\"toEmail\"]','email'),
 (6,2,NULL,'admin',NULL,'{\"gridWidth\":1288.4,\"thWidths\":{\"grid_headcell_icons\":31.4,\"grid_headcell_checkbox\":25.4,\"grid_headcell_details\":40.4,\"grid_headcell_field\":16.4,\"grid_headcell_field1\":160.4,\"grid_headcell_field2\":88.4,\"grid_headcell_field3\":163.4,\"grid_headcell_field4\":81.4,\"grid_headcell_field5\":148.4,\"grid_headcell_field6\":285.4,\"grid_headcell_field7\":256.4,\"grid_headcell_field8\":49.4}}','email'),
 (7,4,NULL,'admin',NULL,'[\"idemail\",\"FromEmail\",\"FromName\",\"toEmail\",\"Date\",\"Subject\",\"Message\",\"Attachment\",\"Status\"]','email'),
 (8,4,NULL,'admin',NULL,'[\"idemail\",\"FromName\",\"FromEmail\",\"toEmail\",\"Subject\",\"Message\",\"Date\",\"Attachment\",\"Status\",\"users_id\"]','v_email');
/*!40000 ALTER TABLE `postreader_settings` ENABLE KEYS */;


--
-- Definition of table `response`
--

DROP TABLE IF EXISTS `response`;
CREATE TABLE `response` (
  `idresponse` int(11) NOT NULL AUTO_INCREMENT,
  `email_idemail` int(11) NOT NULL,
  `response_template_idresponse_template` int(11) NOT NULL,
  `toEmail` varchar(100) NOT NULL,
  `toName` varchar(100) NOT NULL,
  `Subject` varchar(200) NOT NULL,
  `Message` longtext NOT NULL,
  `Status` int(11) DEFAULT NULL,
  PRIMARY KEY (`idresponse`),
  KEY `fk_response_email1_idx` (`email_idemail`),
  KEY `fk_response_response_template1_idx` (`response_template_idresponse_template`),
  CONSTRAINT `fk_response_email1` FOREIGN KEY (`email_idemail`) REFERENCES `email` (`idemail`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_response_response_template1` FOREIGN KEY (`response_template_idresponse_template`) REFERENCES `response_template` (`idresponse_template`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `response`
--

/*!40000 ALTER TABLE `response` DISABLE KEYS */;
INSERT INTO `response` (`idresponse`,`email_idemail`,`response_template_idresponse_template`,`toEmail`,`toName`,`Subject`,`Message`,`Status`) VALUES 
 (1,5,1,'info@fhumanes.com','Fernando Humanes','RE: Prueba de adjuntos','<span style=\"font-weight: bold; color: rgb(128, 0, 0);\">Dear user:</span><br><br>We have proceeded to escalate your message to provide a solution as soon as possible.<br><br>We will get in touch with you shortly.<br><br><div>Greetings,</div><div><br></div><div>------------------------------------------------------------------------------------------------------------</div><div><br></div><div>Hemos procedido a escalar su mensaje para dar solución lo antes posible.<br><br>En breve nos pondremos en contacto con usted.<br><br>Saludos,<br></div>',1),
 (2,5,2,'info@fhumanes.com','Fernando Humanes','RE: Prueba de adjuntos','<b><span style=\"color: rgb(128, 0, 0);\">Dear user:</span></b><br><br>We have fixed the problem. Please give it a try and if you are not satisfied let us know.<br><br><div>Sincerely,</div><div><br></div><div>--------------------------------------------------------------------------------------------------------</div><div><br></div><div>Hemos solucionado el problema. Por favor, prúebelo y si no está satisfecho, háganoslo saber.<br><br>Atentamente, <br></div>		',2);
/*!40000 ALTER TABLE `response` ENABLE KEYS */;


--
-- Definition of table `response_template`
--

DROP TABLE IF EXISTS `response_template`;
CREATE TABLE `response_template` (
  `idresponse_template` int(11) NOT NULL AUTO_INCREMENT,
  `Title` varchar(50) NOT NULL,
  `Text` longtext NOT NULL,
  PRIMARY KEY (`idresponse_template`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `response_template`
--

/*!40000 ALTER TABLE `response_template` DISABLE KEYS */;
INSERT INTO `response_template` (`idresponse_template`,`Title`,`Text`) VALUES 
 (1,'We are working on solving your message','<span style=\"font-weight: bold; color: rgb(128, 0, 0);\">Dear user:</span><br><br>We have proceeded to escalate your message to provide a solution as soon as possible.<br><br>We will get in touch with you shortly.<br><br><div>Greetings,</div><div><br></div><div>------------------------------------------------------------------------------------------------------------</div><div><br></div><div>Hemos procedido a escalar su mensaje para dar solución lo antes posible.<br><br>En breve nos pondremos en contacto con usted.<br><br>Saludos,<br></div>'),
 (2,'Solution','<b><span style=\"color: rgb(128, 0, 0);\">Dear user:</span></b><br><br>We have fixed the problem. Please give it a try and if you are not satisfied let us know.<br><br><div>Sincerely,</div><div><br></div><div>--------------------------------------------------------------------------------------------------------</div><div><br></div><div>Hemos solucionado el problema. Por favor, prúebelo y si no está satisfecho, háganoslo saber.<br><br>Atentamente, <br></div>		');
/*!40000 ALTER TABLE `response_template` ENABLE KEYS */;


--
-- Definition of table `super_catalog`
--

DROP TABLE IF EXISTS `super_catalog`;
CREATE TABLE `super_catalog` (
  `idsuper_catalog` int(11) NOT NULL AUTO_INCREMENT,
  `super_code` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`idsuper_catalog`),
  UNIQUE KEY `super_catalog_ixd1` (`super_code`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `super_catalog`
--

/*!40000 ALTER TABLE `super_catalog` DISABLE KEYS */;
INSERT INTO `super_catalog` (`idsuper_catalog`,`super_code`,`description`) VALUES 
 (1,'LANGUAGE','Languages of the literals'),
 (2,'COMPANY','Type of Companies'),
 (3,'DECISION','Affirmative and negative'),
 (4,'STATUS','Status of email messages');
/*!40000 ALTER TABLE `super_catalog` ENABLE KEYS */;


--
-- Definition of table `users`
--

DROP TABLE IF EXISTS `users`;
CREATE TABLE `users` (
  `user_id` int(10) NOT NULL AUTO_INCREMENT,
  `login` varchar(16) COLLATE utf8_unicode_ci NOT NULL,
  `companies_company_id` int(10) NOT NULL DEFAULT '0',
  `departments_dept_id` int(10) unsigned DEFAULT NULL,
  `username` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `password` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `signature` mediumtext COLLATE utf8_unicode_ci,
  `email` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `color_identifier` varchar(7) COLLATE utf8_unicode_ci NOT NULL DEFAULT '#FFFFFF',
  `reset_token` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `reset_date` datetime DEFAULT NULL,
  PRIMARY KEY (`user_id`),
  KEY `user_username` (`username`),
  KEY `fk_users_companies1_idx` (`companies_company_id`),
  KEY `user_login` (`login`),
  CONSTRAINT `fk_users_companies1` FOREIGN KEY (`companies_company_id`) REFERENCES `companies` (`company_id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `users`
--

/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` (`user_id`,`login`,`companies_company_id`,`departments_dept_id`,`username`,`password`,`signature`,`email`,`color_identifier`,`reset_token`,`reset_date`) VALUES 
 (0,'Not assigned',0,NULL,'','',NULL,'','#F00808',NULL,NULL),
 (4,'admin',3,NULL,'Admistrator','21232f297a57a5a743894a0e4a801fc3',NULL,'info@fhumanes.com','#457CE0',NULL,NULL),
 (5,'user1',3,1,'User 1','24c9e15e52afc47c225b757e7bee1f9d',NULL,'info@fhumanes.com','#F0591D',NULL,NULL),
 (6,'user2',3,NULL,'User 2','7e58d63b60197ceb55a1c487989a3720',NULL,'info@fhumanes.com','#1944D1',NULL,NULL);
/*!40000 ALTER TABLE `users` ENABLE KEYS */;




/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
